<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Users extends Admin_Controller {

    public function __construct() {
        parent::__construct();
    }

    public function login($admin_key = null) {
        if ($this->loggedin()) {
            //اگر کاربر مدیر لاگین کرده بود برو به داشبورد
            redirect('admin/dashboard');
        }

        // Check admin key
        if( $this->settings->admin_key){
            if($admin_key !=  $this->settings->admin_key){
                redirect('errors/error404');
            }
        }

        $submit = $this->input->post('submit');
        if ($submit) {
            $this->data['messages'] = 'نام کاربری یا کلمه عبور وارد شده صحیح نیست';

            $captcha = $this->session->userdata('captcha');
            $this->session->unset_userdata('captcha');

            // اگر چیزی پست شده باشد
            $username = $this->input->post('username');
            $password = $this->input->post('password');

            $this->form_validation->set_rules('username', 'نام کاربری', 'trim|required');
            $this->form_validation->set_rules('password', 'کلمه عبور', 'required');
            $this->form_validation->set_rules('captcha', 'کد امنیتی', "required|callback_is_equal[$captcha]");

            $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
            $this->form_validation->set_message('is_equal', 'لطفا %s را صحیح وارد کنید');

            if ($this->form_validation->run()) {
                // اعتبارسنجی درست بوده و باید در دیتابیس کاربر را چک کنیم
                $user = $this->users_m->login($username);
                if ($user) {

                    if ($user->type == 'admin') {
                        if ($user->kind === $this->users_m->hash($user->type . $username)) {
                            if ($user->password === $this->users_m->hash($password . $username)) {

                                // کاربر رو در سشن بریز
                                $data = array(
                                    'id' => $user->id,
                                    'first_name' => $user->first_name,
                                    'last_name' => $user->last_name,
                                    'user_name' => $user->username,
                                    'email' => $user->email,
                                    'cell_phone' => $user->cell_phone,
                                    'type' => $user->type,
                                    'image' => $user->image,
                                );
                                $this->session->set_userdata($this->login_name_session, json_decode(json_encode($data)));

                                redirect('admin/dashboard');
                            }//if (isset($access_login) && $access_login == TRUE)
                        }
                    }//if($user->type == 'admin')
                }
            } else {
                $this->data['messages'] = validation_errors();
            }
        }

        $this->data['form_action'] = ($this->settings->admin_key) ? base_url('admin-'.$this->settings->admin_key) : base_url('admin/users/login');
        $this->data['captcha_image'] = $this->admin_general->create_captcha();
        $this->data['subview'] = 'admin/user/login';
        $this->load->view('admin/_layout_modal', $this->data);
    }

    // از سشن بررسی می کند که آیا کاربر وارد شده
    public function loggedin() {
        $user = $this->session->userdata($this->login_name_session);

        if ($user)
            return true;
        return false;
    }

    public function logout() {
        if ($this->settings->admin_key) {
            $back_url = ($this->loggedin()) ? 'admin-'.$this->settings->admin_key : 'errors/error404';
        } else {
            $back_url = 'admin/users/login';
        }

        $this->session->sess_destroy();
        redirect($back_url);
    }

    public function index() {
        $this->userHasPermission('users');
        $this->data['meta_title'] = '';
        $this->data['breadcrumb'] = array('مدیران');

        //css
        $css = array();
        array_push($css, 'assets/plugins/data-table/css/dataTables.bootstrap.css');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/data-table/js/jquery.dataTables.min.js');
        array_push($js, 'assets/plugins/data-table/js/dataTables.bootstrap.js');
        $this->data['js'] = $js;

        $where = array(
            'type' => 'admin',
            'deleted' => 0
        );
        $users = $this->users_m->get_by('id, first_name, last_name, block, username', $where);
        $this->data['users'] = $users;

        $this->data['subview'] = 'admin/user/index';
        $this->load->view('admin/_layout_main', $this->data);
    }

    public function view() {
        $this->userHasPermission('users', false);
        $where = array(
            'type' => 'admin',
            'deleted' => 0
        );
        $users = $this->users_m->get_by('id, first_name, last_name,block, username', $where);

        $this->data['users'] = $users;
        echo $this->load->view('admin/user/index', $this->data, true);
    }

    // Add and edit
    function edit($id = null) {

        // check exist
        if ($id != null) {
            $user = $this->users_m->get_by(NULL, array('type' => 'admin', 'id' => $id), true);
            if (!$user)
                $id = null;
        }

        if ($id == null) {
            //add
            $this->userHasPermission('users_add');
            $user = $this->users_m->getNew();
            $this->data['user'] = $user;
        } else {
            //edit
            $this->userHasPermission('users_edit');
            $this->data['user'] = $user;
        }

        $this->load->model('roles_m');
        $this->data['roles'] = $this->roles_m->get_by('title,id', array('for_user' => 'admin'));

        $this->data['subview'] = 'admin/user/edit';
        $this->load->view('admin/_layout_main', $this->data);
    }

    // save
    function save() {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;

        $id = intval($this->input->post('id'));

        //general validation
        $this->form_validation->set_rules('first_name', 'نام', 'trim|required');
        $this->form_validation->set_rules('last_name', 'نام خانوادگی', 'trim|required');
        $this->form_validation->set_rules('email', 'ایمیل', 'required|valid_email');
        $this->form_validation->set_rules('iran_code', 'کد ملی', 'numeric|exact_length[10]');
        $this->form_validation->set_rules('role_id', 'نقش', 'trim|required|numeric');

        //for add
        if ($id == 0) {
            $this->form_validation->set_rules('password', 'رمز عبور', 'required|matches[cf_password]');
            $this->form_validation->set_rules('cf_password', 'تکرار رمز عبور', 'required');
            $this->form_validation->set_rules('username', 'نام کاربری', 'required|is_unique[users.username]');
        }


        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
        $this->form_validation->set_message('numeric', '%s باید عدد باشد');
        $this->form_validation->set_message('matches', '%s با تکرارش باید برابر باشد');
        $this->form_validation->set_message('valid_email', 'لطفا %s را صحیح وارد کنید.');
        $this->form_validation->set_message('is_unique', 'لطفا %s دیگری را وارد کنید');
        $this->form_validation->set_message('exact_length', 'تعداد رقم های  %s صحیح نیست');


        if ($this->form_validation->run() != FALSE) {

            // check exist
            if ($id > 0) {
                $user = $this->users_m->get($id, true);
                if (!$user)
                    $id = 0;
            }


            //general
            $data = array(
                'role_id' =>$this->input->post('role_id'),
                'first_name' => $this->security->xss_clean($this->input->post('first_name')),
                'last_name' => $this->security->xss_clean($this->input->post('last_name')),
                'cell_phone' => $this->input->post('cell_phone'),
                'email' => $this->input->post('email'),
            );

            //image
            $image_result = $this->uploadImage('image');
            if ($image_result->condition) {
                $source_image = $image_result->file_path;
                list($width, $height, $type, $attr) = getimagesize($source_image);
                if ($width != 128 || $height != 128) {
                    //در این حالت نیاز به برش و تغییر اندازه داریم 
                    $this->load->library('image_lib');
                    $config['source_image'] = $source_image;
                    $config['new_image'] = $source_image;
                    $config['maintain_ratio'] = FALSE;
                    $config['width'] = 128;
                    $config['height'] = 128;

                    $this->image_lib->set_enlarge(TRUE);
                    $this->image_lib->thumb($config);
                }
                $data['image'] = $source_image;
            }

            //edit
            if ($id > 0) {
                $this->userHasPermission('users_edit', false, $result);
                $id = $this->users_m->save($data, $id);
            }
            //add
            else {
                $this->userHasPermission('users_add', false, $result);
                $data['username'] = $this->security->xss_clean($this->input->post('username'));
                $data['type'] = 'admin';
                $data['kind'] = $this->users_m->hash('admin' . $data['username']);
                $data['activation'] = 1;
                $data['password'] = $this->users_m->hash($this->input->post('password') . $data['username']);
                $id = $this->users_m->save($data);
            }
            
            $result->msg = 'با موفقیت ثبت گردید';
            $this->session->set_flashdata('admin_success', $result->msg);
            $result->condition = true;
            $result->url = base_url('admin/users');
        } else {
            $result->msg = validation_errors();
        }

        echo json_encode($result);
    }


    public function delete($id = NULL) {
        $id = intval($id);
        $data = array(
            'deleted' => '1'
        );
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('users_delete', false, $result);


        if ($id > 0) {
            $this->users_m->update_by($data, array('id' => $id, 'type' => 'admin'));
            $result->msg = 'کاربر مورد نظر با موفقیت حذف شد.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->users_m->update_by($data, array('id' => $id, 'type' => 'admin'));
                    }
                    $result->msg = 'کاربرهای مورد نظر با موفقیت حذف شدند.';
                    $result->condition = true;
                }
            }
        }
        echo json_encode($result);
    }

    private function uploadImage($name = NULL) {
        $result = new stdClass();
        $result->condition = FALSE;
        if ($name) {

            $this->load->library('upload');
            $this->load->helper('string');

            $output_dir = "media/users/";
            $fileName = random_string('alnum', 8) . '-' . random_string('alnum', 4) . '-' . random_string('alnum', 4) . '-' . random_string('alnum', 4) . '-' . random_string('alnum', 12) . '.jpg';
            $config['upload_path'] = $output_dir;
            $config['file_name'] = $fileName;
            $config['allowed_types'] = 'gif|jpg|png';
            $config['max_size'] = 2048; //(in kilobyte) 2 MB = 2048 KB


            $this->upload->initialize($config);
            if (!$this->upload->do_upload($name)) {
                $result->error = array('error' => $this->upload->display_errors());
            //if (!move_uploaded_file($_FILES[$name]['tmp_name'], $output_dir.$fileName)) {
            //     $result->error = 'Error in uploading.';
            } else {
                $result->condition = TRUE;
                $result->file_name = $fileName;
                $result->file_path = $output_dir . $fileName;
            }
        }
        return $result;
    }

    private function imageResize($source_image) {

        $this->load->library('image_lib');
        $config['image_library'] = 'gd2';
        $config['source_image'] = $source_image;
        $config['new_image'] = "";
        $config['create_thumb'] = FALSE;
        $config['maintain_ratio'] = FALSE;
        $config['width'] = 100;
        $config['height'] = 100;

        $this->image_lib->initialize($config);
        if (!$this->image_lib->resize()) {
//            return $this->image_lib->display_errors();
        }
    }

    private function imageCrop($source_image) {
        $this->load->library('image_lib');
        list($width, $height, $type, $attr) = getimagesize($source_image);
        $min = min($width, $height);
        $config['image_library'] = 'gd2';
        $config['source_image'] = $source_image;
        $config['new_image'] = "";
        $config['x_axis'] = ceil(($width - $min) / 2);
        $config['y_axis'] = ceil(($height - $min) / 2);
        $config['maintain_ratio'] = FALSE;
        $config['width'] = $min;
        $config['height'] = $min;

        $this->image_lib->initialize($config);
        if (!$this->image_lib->crop()) {
//            return $this->image_lib->display_errors();
        }
    }

    //remove image
    public function removeImage($id = 0) {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = FALSE;

        $this->userHasPermission('users_edit', false, $result);


        $id = intval($id);
        if ($id != 0) {
            $where = array(
                'id' => $id,
                'type' => 'admin'
            );
            $user = $this->users_m->get_by(NULL, $where, TRUE);
            if ($user) {
                if ($user->image != '' && file_exists($user->image)) {
                    unlink($user->image);
                    $data = array(
                        'image' => ''
                    );
                    $this->users_m->save($data, $id);
                }
                $result->condition = TRUE;
            }
        }

        echo json_encode($result);
    }

    public function changePasswordEdit($id = null) {
        $this->userHasPermission('users_edit');

        // check exist
        $id = intval($id);
        if ($id > 0) {
            $user = $this->users_m->get_by('id, first_name, last_name, username', array('type' => 'admin', 'id' => $id), true);
            if (!$user)
                die();
        }
        $this->data['user'] = $user;

        $this->data['meta_title'] = '';
        $this->data['breadcrumb'] = array('تغییر رمز عبور');
        $this->data['sub_title'] = '';



        $this->data['subview'] = 'admin/user/change_password';
        $this->load->view('admin/_layout_main', $this->data);
    }

    public function changePasswordSave() {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->message = 'خطای امنیتی';

        $this->userHasPermission('users_edit', false, $result);

        $id = intval($this->input->post('id'));
        if ($id > 0) {
            $user = $this->users_m->get_by('id, first_name, last_name, username', array('type' => 'admin', 'id' => $id), true);
            if ($user) {
                $this->form_validation->set_rules('password', 'رمز عبور جدید', 'required|matches[cf_password]|min_length[5]');
                $this->form_validation->set_rules('cf_password', 'تکرار رمز عبور جدید', 'required');

                $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
                $this->form_validation->set_message('min_length', '%s حداقل باید 5 کاراکتر باشد');
                $this->form_validation->set_message('matches', '%s با تکرارش باید برابر باشد');

                if ($this->form_validation->run() != FALSE) {

                    $data = array();
                    $data['password'] = $this->users_m->hash($this->input->post('password') . $user->username);

                    $this->users_m->save($data, $id);

                    $result->msg = 'با موفقیت ثبت گردید';
                    $result->condition = true;
                    $result->url = base_url('admin/users');
                } else {
                    $result->msg = validation_errors();
                }
            }
        }

        echo json_encode($result);
    }

    //for captcha
    function is_equal($str, $value) {
        return (strtoupper($str) === strtoupper($value));
    }

    public function block($id = NULL) {
        $id = intval($id);
        $data = array(
            'block' => '1'
        );
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;

        $this->userHasPermission('users_edit', false, $result);

        $result->msg = 'موردی انتخاب نشده است.';
        if ($id > 0) {
            $this->users_m->update_by($data, array('id' => $id, 'type' => 'admin'));
            $result->msg = 'کاربر مورد نظر با موفقیت بلاک شد.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->users_m->update_by($data, array('id' => $id, 'type' => 'admin'));
                    }
                    $result->msg = 'کاربرهای مورد نظر با موفقیت بلاک شدند.';
                    $result->condition = true;
                }
            }
        }
        echo json_encode($result);
    }

    public function unblock($id = NULL) {
        $id = intval($id);
        $data = array(
            'block' => '0'
        );

        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('users_edit', false, $result);

        if ($id > 0) {
            $id = intval($id);
            $this->users_m->update_by($data, array('id' => $id, 'type' => 'admin'));
            $result->msg = 'کاربر مورد نظر با موفقیت بازیابی شد.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->users_m->update_by($data, array('id' => $id, 'type' => 'admin'));
                    }
                    $result->msg = 'کاربر های مورد نظر با موفقیت بازیابی شدند.';
                    $result->condition = true;
                }
            }
        }

        echo json_encode($result);
    }


}
