<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Update extends Admin_Controller
{

    public function index()
    {
        $this->load->library('migration');

        // Offline site
        $this->settings_m->save(['value' => 1], 'offline');

        // Delete migratian that deleted
        $this->unlinkMigrationFiles();
        
        // if ($this->migration->version(20250816133000) === FALSE) {
        if ($this->migration->latest() === FALSE) {
            show_error($this->migration->error_string());
        } else {
            $new_version = '5.5.0';

            // Get current version
            $current_version = $this->settings_m->getSingle('version');

            // Dangerous files
            $number_of_dangerous_files = count($this->getDangerousFiles());
            if($number_of_dangerous_files){
                $error = 'خریدار گرامی کارتا، فایل مشکوکی روی هاست شما قرار دارد و ممکن است موجب آسیب امنیتی جدی شود.<br>';
                $error .= 'لطفا از طریق <strong>تیکت راستچین</strong> یا ایمیل info@rayanik.com به ما پیام دهید.<br>';
                $error .= 'لازم به ذکر هست که در <strong>تیکت راستچین</strong> سریع‌تر به پیام شما رسیدگی می‌شود.<br>';
                $error .= 'با احترام<br>';
                $error .= 'تیم توسعه اسکریپت کارتا';
                $this->session->set_flashdata('error', $error);
            }
            
            // Send
            if(version_compare($new_version, $current_version) === 1){
                $this->load->library('update_lib');
                $this->update_lib->send((object)[
                    'from' => $current_version,
                    'to' => $new_version,
                    'action' => 'update',
                    'number_of_dangerous_files' => $number_of_dangerous_files,
                ]);
            }

            $this->settings_m->save(['value' => $new_version], 'version');

            // Online site
            $this->settings_m->save(['value' => 0], 'offline');

            $this->session->set_flashdata('update_successfull', $new_version);
            redirect('admin/dashboard');
        }
    }

    public function getDangerousFiles($rename=true){
        $result = [];
        $dangerous_extensions = ['phtml', 'php', 'inc'];
        
        foreach($dangerous_extensions as $extension){
            $chars_for_regex = '';// We need this pattern for regex => [pP][hH][tT][mM][lL]
            for($i=0; $i<strlen($extension); $i++){
                $chars_for_regex .= '[' . strtolower($extension[$i]) . strtoupper($extension[$i]) .']';
            }
            
            $dirs = ['customer_upload', 'profiles', 'tickets'];
            
            foreach ($dirs as $dir) {
                $dangerous_files = glob("media/$dir/*.$chars_for_regex*");
    
                if($dangerous_files){
                    foreach($dangerous_files as $file ){
                        $result[] = basename($file);
                        $new_file = rtrim($file, '0');
                        if($rename){
                            rename($file, $new_file . '0');
                        }
                    }
                }
            }

        }

        // var_dump($result);
        return $result;
    }

    private function unlinkMigrationFiles(){
        $migrations_path = APPPATH . 'migrations/';

        // لیست فایل‌هایی که می‌خواهید حذف کنید
        $files = [
            '20221219162500_Alter_orders_view.php',
            '20231014095600_Alter_orders_view.php',
            '20231230112903_Alter_orders_view.php',
        ];

        foreach ($files as $file) {
            $filePath = $migrations_path . $file;

            if (file_exists($filePath)) {
                unlink($filePath);
            }
        }
    }

}

