<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Tickets extends Admin_Controller
{

    function __construct()
    {
        parent::__construct();

        $this->load->model('tickets_m');
        $this->load->model('messages_m');
    }

    function index($user_id = null)
    {
        $this->userHasPermission('tickets');
        $this->data['meta_title'] = 'تیکت ها';
        $this->data['breadcrumb'] = array('تیکت ها');

        //css
        $css = array();
        array_push($css, 'assets/plugins/data-table/css/dataTables.bootstrap.css');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/data-table/js/jquery.dataTables.min.js');
        array_push($js, 'assets/plugins/data-table/js/dataTables.bootstrap.js');
        $this->data['js'] = $js;

        // User
        $user_id = intval($user_id);
        $user = null;
        if($user_id){
            $user = $this->users_m->get_by("id, CONCAT(first_name, ' ', last_name) AS full_name, cell_phone", ['id' => $user_id, 'type' => 'customer', 'deleted' => 0], true);
        }
        $this->data['user'] = $user;

        // Categories
        $this->load->model('categories_m');
        $this->data['categories'] = $this->categories_m->get_by('id, title_fa as title', ['type' => 'ticket', 'deleted' => 0], false, 'ordering');


        $this->data['subview'] = 'admin/ticket/index';
        $this->load->view('admin/_layout_main', $this->data);
    }

    function view($user_id = null)
    {
        $this->userHasPermission('tickets', false);

        // User
        $user_id = intval($user_id);
        $user = null;
        if($user_id){
            $user = $this->users_m->get_by("id, CONCAT(first_name, ' ', last_name) AS full_name, cell_phone", ['id' => $user_id, 'type' => 'customer', 'deleted' => 0], true);
        }
        $this->data['user'] = $user;

        echo $this->load->view('admin/ticket/index', $this->data, true);
    }

    public function ajax_list($user_id = null)
    {
        $this->userHasPermission('tickets', false);
        $user_id = intval($user_id);
        if($user_id){
            $this->tickets_m->filter = ['user_id' => $user_id];
        }

        if (isset($_POST['columns']) && is_array($_POST['columns'])) {
            foreach ($_POST['columns'] as $key => $column) {
                if($column['data'] == 'unread_admin' && $column['search']['value']!=''){
                    if($column['search']['value'] == 1){
                        $this->tickets_m->filter['unread_admin'] = 0;
                    } else {
                        $this->tickets_m->filter['unread_admin >'] = 0;
                    }
                    $_POST['columns'][$key]['search']['value'] = '';
                }

                if($column['data'] == 'category_title' && $column['search']['value']!=''){
                    $this->tickets_m->filter['category_id'] = intval($column['search']['value']);
                    $_POST['columns'][$key]['search']['value'] = '';
                }

                if($column['data'] == 'priority' && $column['search']['value']!=''){
                    $this->tickets_m->filter['priority'] = $column['search']['value'];
                    $_POST['columns'][$key]['search']['value'] = '';
                }

                if($column['data'] == 'status' && $column['search']['value']!=''){
                    $this->tickets_m->filter['status'] = $column['search']['value'];
                    $_POST['columns'][$key]['search']['value'] = '';
                }
            }
        }
        $list = $this->tickets_m->get_datatables();
        $data = array();
        $no = $_POST['start'];
        $base_url = trim(base_url(), '/');
        foreach ($list as $item) {
            $item->title = html_escape($item->title);
            $item->full_name = html_escape($item->full_name);

            $target_blank = ($user_id) ? 'target="_blank"' : '';

            //actions
            $actions = "";
            if (in_array('messages', $this->user_permissions)){
                $actions .= "<a class=\"btn btn-sm btn-info btn-round\" href=\"$base_url/admin/tickets/messages/$item->id\" $target_blank >مشاهده</a>";
            }
            if (in_array('tickets_edit', $this->user_permissions)){
                $actions .= "<a title=\"ویرایش\" class=\"btn btn-sm btn-warning btn-round btn-icon has-tooltip\" href=\"$base_url/admin/tickets/edit/$item->id\" ><i class=\"icon-pencil\"></i></a>";
            }
            if (in_array('tickets_delete', $this->user_permissions)){
                $actions .= " <a  title=\"حذف\" class=\"btn btn-sm btn-danger btn-round  btn-icon has-tooltip\" href=\"javascript: void(0)\" onclick=\"deleteRow('$base_url/admin/tickets/delete/$item->id','','$base_url/admin/tickets/view/$user_id}','#res','deleteSingle','GET')\"><i class=\"icon-trash\"></i></a>";
            }

            // Unread admin
            $unread_admin_html = ($item->unread_admin) ? "<span class=\"badge badge-danger has-tooltip\" title=\"پیام مشاهده نشده دارید\">$item->unread_admin</span>" : '';

            // Status
            switch ($item->status) {
                case 'close':
                    $status_html = '<span class="text-danger">بسته شده</span>';
                    break;
                case 'pending':
                    $status_html = '<span class="text-warning">در انتظار</span>';
                    break;
                case 'done':
                    $status_html = '<span class="text-success">پاسخ داده شده</span>';
                    break;
                default:
                    $status_html = '';
                    break;
            }
            $no++;
            $row = array();
            $row['checkbox'] = '<input type="checkbox" value="' . $item->id . '">';
            $row['row'] = $no;
            $row['title'] = $unread_admin_html . " <div class=\"ticket-in-table ellipsis\" title=\"$item->title\"><a href=\"$base_url/admin/tickets/messages/$item->id\" $target_blank >$item->title</a></div>";;
            $row['full_name'] = $item->full_name;
            $row['username'] = "<p>$item->full_name</p><p class=\"m-t-5\">$item->username</p>";
            $row['category_title'] = $item->category_title;
            $row['priority'] = translatePriority($item->priority);
            $row['unread_admin'] = $item->unread_admin;
            $row['status'] = $status_html;
            $row['updated'] = $this->pdate->date('l j F H:i', strtotime($item->updated));
            $row['actions'] = $actions;
            $row['id'] = $item->id;
            $data[] = $row;
        }

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->tickets_m->count_all(),
            "recordsFiltered" => $this->tickets_m->count_filtered(),
            "data" => $data,
            "csrf" => $this->security->get_csrf_hash()
        );
        // Output to json format
        echo json_encode($output);
    }

    // Add and edit
    function edit($id = null)
    {
        //$this->data['meta_title'] = '';
        $this->data['breadcrumb'] = array('تیکت ها');

        // check exist
        if ($id != null) {
            $ticket = $this->tickets_m->get_by(NULL, ['id' => $id], true);
            if (!$ticket)
                $id = null;
        }

        if ($id == null) {
            // add 
            $this->userHasPermission('tickets_add');
            $this->data['action'] = 'add';
            $ticket = $this->tickets_m->getNew();
            $this->data['ticket'] = $ticket;
        } else {
            // edit 
            $this->userHasPermission('tickets_edit');
            $this->data['action'] = 'edit';

            $user = $this->users_m->get_by('cell_phone', ['id' => $ticket->user_id], true);
            $ticket->cell_phone = ($user) ? $user->cell_phone : '';

            $this->data['ticket'] = $ticket;
        }

        // دسته بندی
        $this->load->model('categories_m');
        $this->data['categories'] = $this->categories_m->get_by('id , title_fa as title', array('type' => 'ticket', 'publish' => 1, 'deleted' => 0), false, 'ordering');

        $this->data['subview'] = 'admin/ticket/edit';
        $this->load->view('admin/_layout_main', $this->data);
    }


    // Save
    function save()
    {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->msg = 'خطا سیستمی.';
        $result->condition = false;

        $id = intval($this->input->post('id'));

        // check exist
        if ($id != 0) {
            $ticket = $this->tickets_m->get_by(NULL, ['id' => $id], true);
            if (!$ticket)
                $id = 0;
        }

        if (!$id) {
            $this->form_validation->set_rules('cell_phone', 'شماره همراه', ['trim', 'required', 'regex_match[/^9\d{9}$|^09\d{9}$/]']);
        }
        $this->form_validation->set_rules('title', 'عنوان', "trim|required");
        $this->form_validation->set_rules('category_id', 'بخش', "trim|required|integer");
        $this->form_validation->set_rules('priority', 'فوریت', "trim|required|in_list[low,normal,high]");
        if (!$id) {
            $this->form_validation->set_rules('text', 'متن', "trim|required");
        }

        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
        $this->form_validation->set_message('integer', 'لطفا %s را صحیح انتخاب کنید');
        $this->form_validation->set_message('in_list', 'لطفا %s را صحیح انتخاب کنید');

        if ($this->form_validation->run() != FALSE) {

            // Check cell phone
            if(!$id){
                $cell_phone = $this->input->post('cell_phone');
                if(strlen($cell_phone) == 10){
                    $cell_phone = '0' . $cell_phone;
                }

                $user = $this->users_m->get_by('id', ['cell_phone' => $cell_phone, 'type' => 'customer', 'deleted' => 0], true);
                if(!$user){
                    $result->msg = 'این شماره همراه وجود ندارد.';
                    echo json_encode($result, JSON_UNESCAPED_UNICODE);
                    die();
                }
            }

            $data =[
                'category_id' => $this->input->post('category_id'),
                'title' => $this->security->xss_clean($this->input->post('title')),
                'priority' => $this->input->post('priority'),
            ];

            if(!$id){
                $this->userHasPermission('tickets_add', false, $result);
                $data['user_id'] = $user->id;
                $data['status'] = 'open';
                $data['updated'] = date('Y-m-d H:i:s');
                $id = $this->tickets_m->save($data);

                // Save first message
                $data = [
                    'ticket_id' => $id,
                    'user_id' => $this->user_login->id,
                    'text' => $this->security->xss_clean($this->input->post('text')),
                    'reading' => 0,
                ];

                // Attach
                $upload_result = $this->uploadFile('attach');
                if ($upload_result->condition) {
                    $data['attach'] = $upload_result->file_path;
                }

                $this->messages_m->save($data);
                $this->tickets_m->updateUnreadAndLastMessage($id, 'customer');

            } else {
                $this->userHasPermission('tickets_edit', false, $result);
                $this->tickets_m->save($data, $id);
            }
            
            $result->msg = '';
            if(isset($upload_result->error)){
                $this->session->set_flashdata('admin_error', 'تیکت شما ثبت گردید اما فایل پیوست دارای خطا بود:' . $upload_result->error);
            } else {
                $this->session->set_flashdata('admin_success', 'تیکت با موفقیت ثبت گردید.');
            }
            $result->condition = true;
            $result->url = base_url('admin/tickets');
        } else {
            $result->msg = validation_errors();
        }

        echo json_encode($result, JSON_UNESCAPED_UNICODE);
    }


    function messages($ticket_id = null)
    {
        $this->userHasPermission('messages');
        $this->data['meta_title'] = 'تیکت ها';
        $this->data['breadcrumb'] = 'تیکت ها';

        // Check exists
        $ticket_id = intval($ticket_id);
        $ticket = $this->tickets_m->getDetail($ticket_id);
        if (!$ticket) {
            redirect('admin/tickets');
        }
        $this->data['ticket'] = $ticket;

        //به دست آوردن تمام پیام های این تیکت
        $messages = $this->tickets_m->getMessages($ticket_id);
        $this->data['messages'] = $messages;
        $this->load->library('pdate');
        if ($messages) {
            // User profile image
            $default_ptofile_image = $this->settings_m->getSingle('profile_image');
            if($ticket->user_image && file_exists($ticket->user_image)){
                $customer_image = $ticket->user_image;
            } else if($default_ptofile_image && file_exists($default_ptofile_image)){
                $customer_image = $default_ptofile_image;
            } else {
                $customer_image = 'assets/admin/images/user/avatar128.png';
            }

            $admin_images = [];

            $first_message_unread = true;
            foreach ($messages as $key => $message) {
                $messages[$key]->created = $this->pdate->date('j ام F، H:i', strtotime($message->created));

                // Image
                if($message->user_id == $ticket->user_id){
                    $messages[$key]->user_image = $customer_image;
                } else {
                    if(!isset($admin_images[$message->user_id])){
                        if($message->user_image && file_exists($message->user_image)){
                            $admin_image = $message->user_image;
                        } else {
                            $admin_image = 'assets/admin/images/user/avatar128.png';
                        }
                        $admin_images[$message->user_id] = $admin_image;
                    }
                    $messages[$key]->user_image = $admin_images[$message->user_id];
                }

                //پیدا کردن اولین پیامی که خوانده نشده است
                if ($first_message_unread && $message->reading == '0' && $message->user_id == $ticket->user_id) {
                    $this->data['first_message_unread'] = $message->id;
                    $first_message_unread = false;
                }
            }
        }

        //پیام های که کاربر به مدیر در این تیکت فرستاده است را به وضعیت خوانده شده تغییر می دهیم
        $this->messages_m->update_by(array('reading' => 1), array('reading' => '0', 'ticket_id' => $ticket_id, 'user_id' => $ticket->user_id));
        $this->tickets_m->updateUnreadAndLastMessage($ticket_id, 'admin');

        //تعداد پیام های خوانده نشده 
        $this->data['number_of_message'] = $this->tickets_m->getUnreadMessagesByAdmin();

        $this->data['subview'] = 'admin/ticket/messages';
        $this->load->view('admin/_layout_main', $this->data);
    }

    //ذخیره پیام
    function messageSave()
    {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'خطای سیستمی';
        $result->csrf = $this->security->get_csrf_hash();

        // Check exists
        $ticket_id = intval($this->input->post('ticket_id'));
        $ticket = $this->tickets_m->get_by(null, array('id' => $ticket_id), true);
        if (!$ticket) {
            $result->msg = 'عدم دسترسی';
            echo json_encode($result);
            die();
        }

        $message_id = intval($this->input->post('message_id'));

        $this->form_validation->set_rules('text', 'متن پیام', 'trim|required');
        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
        if ($this->form_validation->run() != FALSE) {

            $data = array(
                'text' => $this->security->xss_clean($this->input->post('text')),
            );
            if ($message_id) {
                $this->userHasPermission('messages_edit', false, $result);
                $id = $this->messages_m->save($data, $message_id);
                $action = 'edit';
            } else {
                $this->userHasPermission('messages_add', false, $result);
                $data['ticket_id'] = $ticket_id;
                $data['user_id'] = $this->user_login->id;
                $data['reading'] = 0;

                // Attach
                $upload_result = $this->uploadFile('attach');
                if ($upload_result->condition) {
                    $data['attach'] = $upload_result->file_path;
                }

                $id = $this->messages_m->save($data);
                $action = 'add';

                // تعداد پیام های خوانده نشده را برای این کاربر یک واحد کاهش می دهیم
                $this->tickets_m->updateUnreadAndLastMessage($ticket_id, 'customer');

                // اگر تیکت بسته بود بازش می کنیم
                if($ticket->status == 'close'){
                    $this->tickets_m->save(['status' => 'open'], $ticket_id);
                }
            }

            if ($id) {
                $result->msg = 'با موفقیت ثبت گردید.';
                $this->session->set_flashdata('admin_success', $result->msg);
                $result->condition = true;
                if ($action == 'add') {
                    $result->msg = '';
                    if(isset($upload_result->error)){
                        $this->session->set_flashdata('admin_error', 'پیام شما ثبت گردید اما فایل پیوست دارای خطا بود:' . $upload_result->error);
                    } else {
                        $this->session->set_flashdata('admin_success', 'پیام شما ثبت گردید.');
                    }
                    $result->url = base_url("admin/tickets/messages/$ticket_id");
                }
            }
        } else {
            $result->msg = validation_errors();
        }

        echo json_encode($result);
    }

    function delete($id = NULL)
    {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';
        $result->csrf = $this->security->get_csrf_hash();

        $this->userHasPermission('tickets_delete', false, $result);

        $ids = array();
        $id = intval($id);
        if ($id > 0) {
            array_push($ids, $id);
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                foreach ($checkb as $id) {
                    $id = intval($id);
                    array_push($ids, $id);
                }
            }
        }

        if ($ids) {
            $str_ids = implode(',', $ids);
            $tickets = $this->tickets_m->get_by('id', array("id IN ($str_ids)" => null));
            if ($tickets) {
                $ids = array_map(function ($item) {
                    return $item->id;
                }, $tickets);
                $str_ids = implode(',', $ids);

                // حذف پیوست های تمام پیام ها در صورت وجود
                $all_messages = $this->messages_m->get_by('attach', array("ticket_id IN ($str_ids)" => null));
                foreach($all_messages as $message){
                    if($message->attach && file_exists($message->attach)){
                        unlink($message->attach);
                    }
                }


                $this->tickets_m->delete_by(array("id IN ($str_ids)" => null));
                $this->messages_m->delete_by(array("ticket_id IN ($str_ids)" => null));

                //Set message
                if (count($ids) == 1) {
                    $result->msg = 'تیکت مورد نظر با موفقیت حذف شد.';
                } else {
                    $result->msg = 'تیکت های مورد نظر با موفقیت حذف شدند.';
                }
                $result->condition = true;
            }
        }
        echo json_encode($result);
    }

    //delete
    function messageDelete($id = null)
    {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'خطا';

        $this->userHasPermission('messages_delete', false, $result);

        $id = intval($id);
        if ($id) {
            $message = $this->messages_m->get_by('ticket_id, attach', ['id' => $id], true);
            if($message){

                $this->messages_m->delete($id);
                $result_update = $this->tickets_m->updateUnreadAndLastMessage($message->ticket_id, 'customer');

                // حذف فایل پیوست در صورت وجود
                if($message->attach && file_exists($message->attach)){
                    unlink($message->attach);
                }

                // اگر تعداد پیام هاش صفر شده بود آنگاه خود تیکت را حذف می کنیم و میندازیمش بیرون
                if($result_update->last_message_id){
                    $result->msg = 'پیام مورد نظر با موفقیت حذف شد.';
                } else {
                    $this->tickets_m->delete($message->ticket_id);

                    $result->msg = '';
                    $this->session->set_flashdata('admin_success', 'پیام و تیک با موفقیت حذف شدند.');
                    $result->url = base_url('admin/tickets');
                }
                
                $result->condition = true;

            }
        }
        echo json_encode($result);
    }

    function changeStatus($status = '', $id = NULL)
    {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('tickets_edit', false, $result);

        if(!in_array($status, ['open', 'close'])){
            $result->msg = 'عملیات خواسته شده نامعتبر است.';
            echo json_encode($result);
            die();
        }

        $posted_ids = [];
        $id = intval($id);
        if ($id > 0) {
            $posted_ids[] = $id;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $posted_ids[] = intval($id);
                    }
                }
            }
        }

        if($posted_ids){
            $str_ids = implode(',', $posted_ids);
            $this->tickets_m->update_by(['status' => $status], ["id IN ($str_ids)" => null]);
           
            $result->condition = true;
            if($status == 'close'){
                if(count($posted_ids) == 1){
                    $result->msg = 'تیکت مورد نظر در وضعیت بسته قرار گرفت.';
                } else {
                    $result->msg = 'تیکت های مورد نظر در وضعیت بسته قرار گرفتند.';
                }
                $result->script = '$(".btn-ticket-close").addClass("hide");';
                $result->script .= '$(".btn-ticket-open").removeClass("hide");';
            } else {
                if(count($posted_ids) == 1){
                    $result->msg = 'تیکت مورد نظر در وضعیت باز قرار گرفت.';
                } else {
                    $result->msg = 'تیکت های مورد نظر در وضعیت باز قرار گرفتند.';
                }
                $result->script = '$(".btn-ticket-open").addClass("hide");';
                $result->script .= '$(".btn-ticket-close").removeClass("hide");';
            }   
            
        }
       
        echo json_encode($result);

    }

    private function uploadFile($name)
    {
        $result = new stdClass();
        $result->condition = FALSE;
        if($name && isset($_FILES[$name]) && $_FILES[$name]["size"]) {
            $this->load->library('upload');

            // Check upload path
            $output_dir = "media/tickets/";
            if (!file_exists($output_dir)) {
                mkdir($output_dir, 0755, true);
            }

            $file_extension = pathinfo($_FILES[$name]['name'], PATHINFO_EXTENSION);
            $fileName = date('Ymd-His'). '-' . random_str(5) . '-' . random_str(10) . '.' . $file_extension;
            $config['upload_path'] = $output_dir;
            $config['file_name'] = $fileName;
            $config['allowed_types'] = 'docx|txt|pptx|ppt|zip|pdf|jpg|jpeg|png';
            $config['max_size'] = 10240; //(in kilobyte) 10 MB = 10240 KB

            $this->upload->initialize($config);

            if (!$this->upload->do_upload($name)) {
                $result->error = $this->upload->display_errors();
            } else {
                $result->condition = TRUE;
                $result->file_name = $fileName;
                $result->file_path = $output_dir . $fileName;
            }
        }
        
        return $result;
    }

    public function download($message_id = null){
        $message_id = intval($message_id);
        $message = $this->messages_m->get_by(null, ['id' => $message_id], true);

        if(!$message){
            redirect('errors/error404');
        }

        if(empty($message->attach) || !file_exists($message->attach)){
            redirect('errors/error404');
        }

        $this->load->helper('download');
        force_download($message->attach, NULL);

    }
}
