<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Settings extends Admin_Controller {

    function __construct() {
        parent::__construct();

        $this->userHasPermission('settings');
        $this->load->model('settings_m');
    }

    function index($active_tab = NULL) {
        $this->load->library('admin_general');

        $this->data['active_tab'] = ($active_tab != NULL) ? $active_tab : 'general';
        $this->data['breadcrumb'] = array('تنظیمات');

        //css
        $css = array();
        array_push($css, 'assets/plugins/nestable/nestable.css');
        array_push($css, 'assets/admin/css/admin-colors.css');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/nestable/jquery.nestable.js');
        array_push($js, 'assets/plugins/ckeditor-full/ckeditor.js');
        $this->data['js'] = $js;


        // Get settings
        $settings = $this->settings_m->get();
        if ($settings) {
            foreach ($settings as $key => $setting) {
                $settings[$setting->key] = $setting->value;
                unset($settings[$key]);
            }
            $settings = json_decode(json_encode($settings));
            $settings->social_networks = json_decode($settings->social_networks);
            $settings->rate = json_decode($settings->rate);

            // SMS
            $settings->sms = json_decode($settings->sms);
            if(!isset($settings->sms->patterns->notify_card2card_admin)){
                $settings->sms->patterns->notify_card2card_admin = '';
            }
            if(!isset($settings->sms->patterns->card2card_accept)){
                $settings->sms->patterns->card2card_accept = '';
            }
            if(!isset($settings->sms->patterns->card2card_reject)){
                $settings->sms->patterns->card2card_reject = '';
            }
        }
        $this->data['settings'] = $settings;

        // For Theme
        $colors_json = $theme_colors_arr = $theme_colors = $theme_bg_colors = [];
        try {
            $colors_json = $this->getColors();
            if($colors_json){
                $json = json_decode($colors_json, true);
                
                $theme_colors_arr = $json['theme-colors'];
                $theme_colors = array_keys($theme_colors_arr);
                $theme_bg_colors = $json['theme-bg-colors'];
            }
        } catch (\Throwable $th) {
            // nothing
        }
        $this->data['colors_json'] = $colors_json;
        $this->data['theme_colors_arr'] = $theme_colors_arr;
        $this->data['theme_colors'] = $theme_colors;
        $this->data['theme_bg_colors'] = $theme_bg_colors;

       

        $this->data['all_social_networks'] = $this->socialNetworks();

        // Get all contacts
        $this->data['all_method_contacts'] = $this->admin_general->contacts();
        $this->data['show_education_manual_product_modal'] = true;
        $this->data['show_educarion_ui_modal'] = true;

        // Gateways
        $this->load->model('gateways_m');
        // درگاه‌های فعالی که شماره کارت را چک نمی‌کنند
        $this->data['active_gateways_not_check_card'] = $this->gateways_m->get_by('title_en', [
            'deleted' => 0, 
            'publish' => 1, 
            'title_en <>' => 'card2card',
            'check_card' => ''
        ]);

        // لیست درگاه‌های که شماره کارت را چک می‌کنند
        $this->data['gateways_check_card'] = $this->gateways_m->get_by('title_en', [
            'deleted' => 0, 
            'check_card <>' => ''
        ]);

        $this->data['subview'] = 'admin/setting/index';
        $this->load->view('admin/_layout_main', $this->data);
    }

    private function getColors(){
        $url = base_url('assets/json/colors.json');

        $this->load->helper('file');
        $data = read_file('assets/json/colors.json');
        if ($data !== false) {
            return $data;
        }

        if (function_exists('curl_version')) {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_URL, $url);
            $data = curl_exec($ch);
            $error = curl_error($ch);
            curl_close($ch);

            if ($data !== false) {
                return $data;
            }
        }

        if (ini_get('allow_url_fopen')) {
            $data = @file_get_contents($url);
            if ($data !== false) {
                return $data;
            }
        }

        return false;
    }

    // save general
    function saveGeneral() {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'خطای سیستمی.';


        $_POST['dollar_rate'] = str_replace(',', '', $this->input->post('dollar_rate'));
        $_POST['dirham_rate'] = str_replace(',', '', $this->input->post('dirham_rate'));
        $_POST['euro_rate'] = str_replace(',', '', $this->input->post('euro_rate'));
        $_POST['pound_rate'] = str_replace(',', '', $this->input->post('pound_rate'));
        $_POST['lira_rate'] = str_replace(',', '', $this->input->post('lira_rate'));
        $_POST['signup_gift'] = str_replace(',', '', $this->input->post('signup_gift'));

        $this->form_validation->set_rules('site_name', 'نام سایت', "trim|required");
        $this->form_validation->set_rules('admin_key', 'مسیر ادمین', ['trim', 'regex_match[/^[a-zA-Z0-9]+$/]']);
        $this->form_validation->set_rules('meta_title', 'متای عنوان', "trim|required");
        $this->form_validation->set_rules('meta_keywords', 'متای کلمات کلیدی', "trim|required");
        $this->form_validation->set_rules('meta_description', 'متای توضیحات', "trim|required");
        $this->form_validation->set_rules('site_description', 'توضیحات سایت', "trim");
        $this->form_validation->set_rules('signup_gift', 'هدیه ثبت نام', "trim|numeric");
        $this->form_validation->set_rules('dollar_rate', 'نرخ دلار', "trim|required|numeric|greater_than[0]");
        $this->form_validation->set_rules('dirham_rate', 'نرخ درهم', "trim|required|numeric|greater_than[0]");
        $this->form_validation->set_rules('euro_rate', 'نرخ یورو', "trim|required|numeric|greater_than[0]");
        $this->form_validation->set_rules('pound_rate', 'نرخ پوند', "trim|required|numeric|greater_than[0]");
        $this->form_validation->set_rules('lira_rate', 'نرخ لیر', "trim|required|numeric|greater_than[0]");
        $this->form_validation->set_rules('round_price', 'گرد کردن مبلغ', "trim|required|in_list[down-1,up-10,up-100,up-1000,up-10000,down-10,down-100,down-1000,down-10000]");
        $this->form_validation->set_rules('show_gift_box', 'باکس کارت هدیه', "trim|in_list[charge,buy,both]");


        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
        $this->form_validation->set_message('numeric', '%s باید عدد باشد');
        $this->form_validation->set_message('greater_than', '%s بایستی بزرگتر از %s باشد');
        $this->form_validation->set_message('in_list', 'لطفا %s را صحیح انتخاب کنید');
        $this->form_validation->set_message('regex_match', 'لطفا %s را صحیح وارد کنید');

        if ($this->form_validation->run() != FALSE) {
            $data = $this->input->post();

            $list_key = array(
                'meta_title',
                'meta_keywords',
                'meta_description',
                'site_name',
                'site_name_en',
                'site_description',
                'show_coupon_box',
                'show_gift_box',
                'send_admin_invoice',
                'round_price',
                'admin_key',
                'signup_gift',
            );
            foreach ($list_key as $key) {
                if (isset($data[$key])) {
                    if($key == 'show_coupon_box' || $key == 'send_admin_invoice'){
                        $data[$key] = ($data[$key] == 1) ? 1 : 0;
                    }
                    if($key == 'signup_gift'){
                        $data[$key] = ($data[$key]) ? $data[$key] * 1 : 0;
                    }
                    $data_value = array('value' => $data[$key]);
                    $id = $this->settings_m->save($data_value, $key);
                }
            }


            // Currency rate
            $rate = [
                'dollar' => $this->input->post('dollar_rate') * 1,
                'dirham' => $this->input->post('dirham_rate') * 1,
                'euro' => $this->input->post('euro_rate') * 1,
                'pound' => $this->input->post('pound_rate') * 1,
                'lira' => $this->input->post('lira_rate') * 1,
            ];
            $data_value = array('value' => json_encode($rate));
            $this->settings_m->save($data_value, 'rate');

            // Samrt block
            $block_setting = json_decode($this->settings_m->getSingle('smart_block'));
            if($block_setting){
                $blacklist_domains = [];
                $posted_domains = $this->input->post('smart_block[blacklist_domains]');
                $posted_domains = explode(',', $posted_domains);
                foreach ($posted_domains as $domain) {
                    $domain = strtolower(trim($domain));
                    if($domain){
                        $blacklist_domains[] = $domain;
                    }
                }
                $blacklist_domains = array_unique($blacklist_domains);

                $value = json_encode([
                    'active' => ($this->input->post('smart_block[active]') == 1) ? 1 : 0,
                    'blacklist_domains' => $blacklist_domains,
                    
                ]);
                $this->settings_m->save(['value' => $value], 'smart_block');
            }

            $result->msg = 'با موفقیت ثبت گردید';
            $this->session->set_flashdata('success', $result->msg);
            $result->condition = true;
            $result->url = base_url('admin/settings');
        } else {
            $result->msg = validation_errors();
            $result->condition = false;
        }

        echo json_encode($result);
    } 
    
    // Save UI
    function saveUI() {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'خطای سیستمی.';

        $this->form_validation->set_rules('product_ui[count_per_row]', 'تعداد در هر ردیف', "trim|required|in_list[2,3,4,6]");
        $this->form_validation->set_rules('theme[allowed_to_use]', 'تم', "trim|required|in_list[dark,light,both]");
        
        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
        $this->form_validation->set_message('in_list', 'لطفا %s را صحیح انتخاب کنید');

        if ($this->form_validation->run() != FALSE) {
            $data = $this->input->post();

            // Product UI
            $value = [
                'vertical_layout' => ($this->input->post('product_ui[vertical_layout]') == 'true') ? true : false,
                'mobile_vertical_layout' => ($this->input->post('product_ui[mobile_vertical_layout]') == 'true') ? true : false,
                'count_per_row' => $this->input->post('product_ui[count_per_row]'),
            ];
            $this->settings_m->save(['value' => json_encode($value)], 'product_ui');

            // Theme
            $allowed_to_use = $this->input->post('theme[allowed_to_use]');
            $default = $this->input->post('theme[default]');
            if($allowed_to_use == 'both'){
                if(!in_array($default, ['dark', 'light'])){
                    $default = 'light';
                }
            } else {
                $default = $allowed_to_use;
            }
            $value = [
                'allowed_to_use' => $allowed_to_use,
                'default' => $default,
                'color' => $this->input->post('theme[color]'),
                'bg_color' => $this->input->post('theme[bg_color]'),
            ];
            $this->settings_m->save(['value' => json_encode($value)], 'theme');

            $result->msg = 'با موفقیت ثبت گردید';
            $this->session->set_flashdata('success', $result->msg);
            $result->condition = true;
            $result->url = base_url('admin/settings/index/ui');
        } else {
            $result->msg = validation_errors();
            $result->condition = false;
        }

        echo json_encode($result);
    }

    // save pay
    function savePaySettings() {

        //css
        $css = array();
        array_push($css, 'assets/plugins/nestable/nestable.css');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/nestable/jquery.nestable.js');
        $this->data['js'] = $js;

        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'خطای سیستمی.';

        $data = $this->input->post();

        $list_key = array(
            'inaccess_minutes' => '',
        );

        if (20 < $data['inaccess_minutes'] || $data['inaccess_minutes'] < 2)
            $data['inaccess_minutes'] = 10;
        foreach ($list_key as $key => $value) {
            if (isset($data[$key])) {
                $data_value = array('value' => $data[$key]);
                $id = $this->settings_m->save($data_value, $key);
            }
        }

        // Active charge page
        $this->settings_m->save(['value' => ($this->input->post('active_charge_page')) ? 1 : 0], 'active_charge_page');
        
        

        // verify_when_buy
        $verify_when_buy = $this->input->post('verify_when_buy');

        $this->load->model('gateways_m');
        // درگاه‌های فعالی که شماره کارت را چک نمی‌کنند
        $active_gateways_not_check_card = $this->gateways_m->get_by('title_en', [
            'deleted' => 0, 
            'publish' => 1, 
            'title_en <>' => 'card2card',
            'check_card' => ''
        ]);
        if($active_gateways_not_check_card && $verify_when_buy == 'bank_card'){
            // داره شیطنت میکنه
        } else {
            if($verify_when_buy == 'bank_card'){
                $value = ['cell_phone', 'identity_inquiry', 'bank_card'];
            } elseif($verify_when_buy == 'identity_inquiry'){
                $value = ['cell_phone', 'identity_inquiry'];
            } elseif($verify_when_buy == 'cell_phone'){
                $value = ['cell_phone'];
            } else {
                $value = [];
            }
            $this->settings_m->save(['value' => json_encode($value)], 'verify_when_buy');
        }

        // zohal_token
        $value = [
            'site' => 'zohal',
            'token' => $this->input->post('zohal_token'),
        ];
        $this->settings_m->save(['value' => json_encode($value)], 'identity_verification');

        //payment_alerts
        $payment_alerts = array();
        $items = $this->input->post('payment_alerts');
        if ($items) {
            foreach ($items as $item) {
                $item = trim($item);
                if($item){
                    array_push($payment_alerts, $item);
                }
            }
        }
        $data = json_encode($payment_alerts, JSON_UNESCAPED_UNICODE);
        $data_value = array('value' => $data);
        $this->settings_m->save($data_value, 'payment_alerts');

        // Charge Packages
        $charge_packages = [];
        $items = $this->input->post('charge_packages');
        if ($items) {
            foreach ($items as $item) {
                $item = trim($item);
                $item = str_replace(',', '', $item);
                if(is_numeric($item) && $item > 0){
                    array_push($charge_packages, $item * 1);
                }
            }
        }
        $charge_packages = array_unique($charge_packages);
        sort($charge_packages);
        
        $this->settings_m->save(['value' => json_encode($charge_packages)], 'charge_packages');

        $result->msg = 'با موفقیت ثبت گردید';
        $this->session->set_flashdata('success', $result->msg);
        $result->condition = true;
        $result->url = base_url('admin/settings/index/pay');


        echo json_encode($result);
    }

    function saveSmsSettings(){
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'خطای سیستمی.';

        $active = $this->input->post('sms[active]');
        $this->form_validation->set_rules('sms[active]', 'پنل', "trim|in_list[kavenegar,rangine,smsir,melipayamak]");
        if($active){
            $this->form_validation->set_rules('sms[api_key]', 'ApiKey', "trim|required");
            if($active == 'rangine'){
                $this->form_validation->set_rules('sms[from]', 'شماره فرستنده', "trim|required");
            }
        }
        $this->form_validation->set_rules('notification_cell_phone', 'شماره اطلاع رسانی به مدیر', ['trim', 'regex_match[/^9\d{9}$|^09\d{9}$/]']);
        $this->form_validation->set_rules('sms[after_buy]', 'پیامک', "trim|required|in_list[no,codes,successful]");

        $this->form_validation->set_message('in_list', 'لطفا %s را صحیح انتخاب کنید');
        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');

        if ($this->form_validation->run() != FALSE) {

            $data = $this->input->post();
            $list_key = array(
                'notification_cell_phone',
            );
            foreach ($list_key as $key) {
                if (isset($data[$key])) {
                    $data_value = array('value' => $data[$key]);
                    $this->settings_m->save($data_value, $key);
                }
            }

            // Config
            $sms_config = [
                'active' => $this->input->post('sms[active]'),
                'api_key' => $this->input->post('sms[api_key]'),
                'from' => $this->input->post('sms[from]'),
                'after_buy' => $this->input->post('sms[after_buy]'),
                'patterns' => [
                    'verify' => $this->input->post('sms[patterns][verify]'),
                    'successful_buy' => $this->input->post('sms[patterns][successful_buy]'),
                    'notify_sale_admin' => $this->input->post('sms[patterns][notify_sale_admin]'),
                    'notify_card2card_admin' => $this->input->post('sms[patterns][notify_card2card_admin]'),
                    'card2card_accept' => $this->input->post('sms[patterns][card2card_accept]'),
                    'card2card_reject' => $this->input->post('sms[patterns][card2card_reject]'),
                ]
            ];
            $data_value = array('value' => json_encode($sms_config));
            $this->settings_m->save($data_value, 'sms');

            // Auth call
            $auth_call_setting = json_decode($this->settings_m->getSingle('auth_call'));
            if($auth_call_setting){
                $value = json_encode([
                    'active' => ($this->input->post('auth_call[active]') == 1) ? 1 : 0,
                    'platform' => 'kavenegar',
                    'pattern' => $this->input->post('auth_call[pattern]'),
                    
                ]);
                $this->settings_m->save(['value' => $value], 'auth_call');
            }

            $result->msg = 'با موفقیت ثبت گردید';
            $this->session->set_flashdata('success', $result->msg);
            $result->condition = true;
            $result->url = base_url('admin/settings/index/sms');
        } else {
            $result->msg = validation_errors();
            $result->condition = false;
        }

        echo json_encode($result);
    }

    function saveEmailSettings(){
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'خطای سیستمی.';

        $this->form_validation->set_rules('email[method]', 'روش ارسال', "trim|required|in_list[mail,smtp]");

        // For mail method
        $this->form_validation->set_rules('email[host_email]', 'ایمیل هاست', "trim|valid_email");

        // For SMTP method
        //$this->form_validation->set_rules('email[smtp][host]', 'میزبان', "trim|valid_url");
        $this->form_validation->set_rules('email[smtp][user]', 'نام کاربری', "trim|valid_email");
        $this->form_validation->set_rules('email[smtp][port]', 'پورت', "trim|numeric");

        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
        $this->form_validation->set_message('in_list', 'لطفا %s را صحیح انتخاب کنید');
        $this->form_validation->set_message('valid_url', 'لطفا %s را صحیح وارد کنید');
        $this->form_validation->set_message('valid_email', 'لطفا %s را صحیح وارد کنید');
        $this->form_validation->set_message('numeric', '%s باید عدد باشد');

        if ($this->form_validation->run() != FALSE) {
            $data = $this->input->post();

            // Config
            $value = [
                'method' => $this->input->post('email[method]'),
                'host_email' =>  $this->input->post('email[host_email]'),
                'smtp' => [
                    'host' => $this->input->post('email[smtp][host]'),
                    'user' => $this->input->post('email[smtp][user]'),
                    'pass' => $this->input->post('email[smtp][pass]'),
                    'port' => $this->input->post('email[smtp][port]'),
                ],
            ];
            $this->settings_m->save(['value' => json_encode($value)], 'email');

            $result->msg = 'با موفقیت ثبت گردید';
            $this->session->set_flashdata('success', $result->msg);
            $result->condition = true;
            $result->url = base_url('admin/settings/index/email');
        } else {
            $result->msg = validation_errors();
            $result->condition = false;
        }

        echo json_encode($result);
    }

    // ارسال ایمیل تستی
    function sendTestEmail(){
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'ایمیل ارسال نشد.';

        $this->form_validation->set_rules('test[email]', 'ایمیل مقصد', "trim|required|valid_email");
        $this->form_validation->set_rules('test[text]', 'متن ایمیل', "trim|required");

        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
        $this->form_validation->set_message('valid_email', 'لطفا %s را صحیح وارد کنید');

        if ($this->form_validation->run() != FALSE) {
            $this->load->library('frontend_general');
            $settings = $this->settings_m->getSettings([
                'site_name',
                'site_name_en',
                'logo',
            ]);
            
            $to = $this->input->post('test[email]');
            $text = $this->input->post('test[text]');
            $subject = 'Test';

            $result_send = $this->frontend_general->sendEmail($to, $text, null, $subject, $settings->site_name, $settings->site_name_en, $settings->logo);

            if($result_send){
                $result->msg = 'با موفقیت ارسال گردید';
                $result->condition = true;
            } 
        } else {
            $result->msg = validation_errors();
            $result->condition = false;
        }

        echo json_encode($result);
    }

    // save detail
    function saveDetail() {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'خطای سیستمی.';


        $this->form_validation->set_rules('body_script', 'اسکریپت بادی', "trim");
        $this->form_validation->set_rules('header_script', 'اسکریپت هدر', "trim");

        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');

        if ($this->form_validation->run() != FALSE) {
            $data = $this->input->post();
            //var_dump($data);
            $list_key = array(
                'body_script' => '',
                'header_script' => '',
                'enamad' => '',
                'samandehi' => '',
            );
            foreach ($list_key as $key => $value) {
                if (isset($data[$key])) {
                    $data_value = array('value' => $data[$key]);
                    $id = $this->settings_m->save($data_value, $key);
                }
            }
            $result->msg = 'با موفقیت ثبت گردید';
            $this->session->set_flashdata('success', $result->msg);
            $result->condition = true;
            $result->url = base_url('admin/settings/index/detail');
        } else {
            $result->msg = validation_errors();
            $result->condition = false;
        }

        echo json_encode($result);
    }

    //saveImages
    function saveImages() {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $data = $this->input->post();

        //========================== Favicon image ==========================
        $image_result = $this->uploadImage('favicon', TRUE);
        if ($image_result->condition) {
            // $source_image = $image_result->file_path;
            // list($width, $height, $type, $attr) = getimagesize($source_image);

            // if ($height != 32) {
            //     $this->load->library('image_lib');
            //     $config['source_image'] = $source_image;
            //     $config['new_image'] = $source_image;
            //     $config['maintain_ratio'] = FALSE;
            //     $config['width'] = 32;
            //     $config['height'] = 32;

            //     $this->image_lib->set_enlarge(TRUE);
            //     $this->image_lib->thumb($config);
            // }
            $data_value = array('value' => $image_result->file_path);
            $id = $this->settings_m->save($data_value, 'favicon');
        }

        //========================== Logo image ==========================
        $image_result = $this->uploadImage('logo', TRUE);
        if ($image_result->condition) {
            // $source_image = $image_result->file_path;
            // list($width, $height, $type, $attr) = getimagesize($source_image);

            // if ($height != 60 || $width != 60) {
            //     $this->load->library('image_lib');
            //     $config['source_image'] = $source_image;
            //     $config['new_image'] = $source_image;
            //     $config['maintain_ratio'] = FALSE;
            //     $config['width'] = 60;
            //     $config['height'] = 60;

            //     $this->image_lib->set_enlarge(TRUE);
            //     $this->image_lib->thumb($config);
            // }
            $data_value = array('value' => $image_result->file_path);
            $id = $this->settings_m->save($data_value, 'logo');
        }

        //========================= Page 404 image =======================
        $image_result = $this->uploadImage('404_image', TRUE);
        if ($image_result->condition) {
            $data_value = array('value' => $image_result->file_path);
            $id = $this->settings_m->save($data_value, '404_image');
        }

        //========================= Offline image ========================
        $image_result = $this->uploadImage('offline_image', TRUE);
        if ($image_result->condition) {
            $data_value = array('value' => $image_result->file_path);
            $id = $this->settings_m->save($data_value, 'offline_image');
        }
        
        //================= Save default category image ==================
        $image_result = $this->uploadImage('default_category_image', TRUE);
        if ($image_result->condition) {
            $source_image = $image_result->file_path;
            list($width, $height, $type, $attr) = getimagesize($source_image);

            if ($width != 80 || $height != 80) {
                //در این حالت نیاز به برش و تغییر اندازه داریم
                $this->load->library('image_lib');
                $config['source_image'] = $source_image;
                $config['new_image'] = $source_image;
                $config['maintain_ratio'] = FALSE;
                $config['width'] = 80;
                $config['height'] = 80;

                $this->image_lib->set_enlarge(TRUE);
                $this->image_lib->thumb($config);
            }
            $data_value = array('value' => $image_result->file_path);
            $id = $this->settings_m->save($data_value, 'default_category_image');
        }

        //================= Save default category large image ==================
        $image_result = $this->uploadImage('default_category_large_image', TRUE);
        if ($image_result->condition) {
            $source_image = $image_result->file_path;
            list($width, $height, $type, $attr) = getimagesize($source_image);

            if ($width != 480 || $height != 360) {
                //در این حالت نیاز به برش و تغییر اندازه داریم
                $this->load->library('image_lib');
                $config['source_image'] = $source_image;
                $config['new_image'] = $source_image;
                $config['maintain_ratio'] = FALSE;
                $config['width'] = 480;
                $config['height'] = 360;

                $this->image_lib->set_enlarge(TRUE);
                $this->image_lib->thumb($config);
            }
            $data_value = array('value' => $image_result->file_path);
            $id = $this->settings_m->save($data_value, 'default_category_large_image');
        }

        //================= Save login image ==================
        $image_result = $this->uploadImage('login_image', TRUE);
        if ($image_result->condition) {
            $source_image = $image_result->file_path;
            list($width, $height, $type, $attr) = getimagesize($source_image);

            if ($width != 600 || $height != 600) {
                //در این حالت نیاز به برش و تغییر اندازه داریم
                $this->load->library('image_lib');
                $config['source_image'] = $source_image;
                $config['new_image'] = $source_image;
                $config['maintain_ratio'] = FALSE;
                $config['width'] = 600;
                $config['height'] = 600;

                $this->image_lib->set_enlarge(TRUE);
                $this->image_lib->thumb($config);
            }
            $data_value = array('value' => $image_result->file_path);
            $id = $this->settings_m->save($data_value, 'login_image');
        }
        
        //================= Save identity inquiry image ==================
        $image_result = $this->uploadImage('identity_inquiry_image', TRUE);
        if ($image_result->condition) {
            $source_image = $image_result->file_path;
            list($width, $height, $type, $attr) = getimagesize($source_image);

            if ($width != 600 || $height != 600) {
                //در این حالت نیاز به برش و تغییر اندازه داریم
                $this->load->library('image_lib');
                $config['source_image'] = $source_image;
                $config['new_image'] = $source_image;
                $config['maintain_ratio'] = FALSE;
                $config['width'] = 600;
                $config['height'] = 600;

                $this->image_lib->set_enlarge(TRUE);
                $this->image_lib->thumb($config);
            }
            $data_value = array('value' => $image_result->file_path);
            $id = $this->settings_m->save($data_value, 'identity_inquiry_image');
        }

        //================= Save default profile image ==================
        $image_result = $this->uploadImage('profile_image', TRUE);
        if ($image_result->condition) {
            $source_image = $image_result->file_path;
            list($width, $height, $type, $attr) = getimagesize($source_image);

            if ($width != 128 || $height != 128) {
                //در این حالت نیاز به برش و تغییر اندازه داریم
                $this->load->library('image_lib');
                $config['source_image'] = $source_image;
                $config['new_image'] = $source_image;
                $config['maintain_ratio'] = FALSE;
                $config['width'] = 128;
                $config['height'] = 128;

                $this->image_lib->set_enlarge(TRUE);
                $this->image_lib->thumb($config);
            }
            $data_value = array('value' => $image_result->file_path);
            $id = $this->settings_m->save($data_value, 'profile_image');
        }

        $result->msg = 'با موفقیت ثبت گردید';
        $this->session->set_flashdata('success', $result->msg);
        $result->url = base_url('admin/settings/index/images');
        $result->condition = true;

        echo json_encode($result);
    }

    // save general
    function saveOffline() {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'خطای سیستمی.';

        $this->form_validation->set_rules('offline_text', 'متن حالت آفلاین', "trim");
        $this->form_validation->set_rules('offline', 'حالت آفلاین', "required|integer");

        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
        $this->form_validation->set_message('integer', '%s دقیقا باید مشخص شود.');

        if ($this->form_validation->run() != FALSE) {
            $data = $this->input->post();

            $list_key = array(
                'offline' => '',
                'offline_text' => '',
            );
            foreach ($list_key as $key => $value) {
                if (isset($data[$key])) {
                    $data_value = array('value' => $data[$key]);
                    $id = $this->settings_m->save($data_value, $key);
                }
            }

            $result->msg = 'با موفقیت ثبت گردید';
            $this->session->set_flashdata('success', $result->msg);
            $result->condition = true;
            $result->url = base_url('admin/settings/index/offline');
        } else {
            $result->msg = validation_errors();
            $result->condition = false;
        }

        echo json_encode($result);
    }

   //save Social Networks
    function saveSocialNetworks() {

        $all_social_networks = $this->socialNetworks();

        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $data_save = array();
        $data = $this->input->post();
        if (isset($data['social_network']) && count($data['social_network'])) {
            foreach ($data['social_network'] as $key => $social_network) {
                if (isset($all_social_networks[$social_network]) && isset($data['title'][$key]) && isset($data['url'][$key])) {
                    $data_save[] = array(
                        'social_network' => $social_network,
                        'title' => $data['title'][$key],
                        'url' => $data['url'][$key],
                        'class' => $all_social_networks[$social_network]['class'],
                    );
                }
            }
        }

        $data = array();
        $data['value'] = json_encode($data_save, JSON_UNESCAPED_UNICODE);
        $id = $this->settings_m->save($data, 'social_networks');

        $result->msg = 'با موفقیت ثبت گردید';
        $this->session->set_flashdata('success', $result->msg);
        $result->condition = true;
        $result->url = base_url('admin/settings/index/social');

        echo json_encode($result);
    }

    //لیست تمام شبکه های اجتماعی
    function socialNetworks() {
        $list = array(
            'aparat' => array('title' => 'آپارات', 'class' => '<i class="icon-aparat"><span></span><span></span></i>'),
            'facebook' => array('title' => 'فیس بوک', 'class' => 'fa fa-facebook'),
            'twitter' => array('title' => 'تویتر', 'class' => 'fa fa-twitter'),
            'pinterest' => array('title' => 'پینترست', 'class' => 'fa fa-pinterest'),
            'linkedin' => array('title' => 'لینکدین', 'class' => 'fa fa-linkedin'),
            'google_plus' => array('title' => 'گوگل پلاس', 'class' => 'fa fa-google-plus'),
            'tumblr' => array('title' => 'تامبلر', 'class' => 'fa fa-tumblr'),
            'instagram' => array('title' => 'اینستاگرام', 'class' => 'fa fa-instagram'),
            'youtube' => array('title' => 'یوتیوب', 'class' => 'fa fa-youtube'),
            'whatsapp' => array('title' => 'واتس اپ', 'class' => 'fa fa-whatsapp'),
            'telegram' => array('title' => 'تلگرام', 'class' => 'fa fa-send-o')
        );
        return $list;
    }

    //save Contacts
    function saveContacts() {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'خطای سیستمی.';


        $this->form_validation->set_rules('info_email', 'ایمیل سایت', "trim|valid_email");
        $this->form_validation->set_rules('admin_email', 'ایمیل ادمین', "trim|valid_email");

        $this->form_validation->set_message('valid_email', 'لطفا %s را صحیح وارد کنید');

        if ($this->form_validation->run() != FALSE) {
            $data = $this->input->post();

            $list_key = array(
                'address' => '',
                'info_email' => '',
                'admin_email' => '',
                'phone1' => '',
                'phone2' => ''
            );
            foreach ($list_key as $key => $value) {
                if (isset($data[$key])) {
                    $data_value = array('value' => $data[$key]);
                    $id = $this->settings_m->save($data_value, $key);
                }
            }

            // Ticket
            $value = [
                'allow_close' => ($this->input->post('ticket[allow_close]') == 1) ? 1 : 0,
                'allow_send_after_close' =>  ($this->input->post('ticket[allow_send_after_close]') == 1) ? 1 : 0,
                'allowed_user_files' => $this->input->post('ticket[allowed_user_files]') ?: [],
            ];
            $this->settings_m->save(['value' => json_encode($value)], 'ticket');

            $result->msg = 'با موفقیت ثبت گردید';
            $this->session->set_flashdata('success', $result->msg);
            $result->condition = true;
            $result->url = base_url('admin/settings/index/contact');
        } else {
            $result->msg = validation_errors();
            $result->condition = false;
        }

        echo json_encode($result);
    }

    // Upload Image
    private function uploadImage($name = NULL) {
        $result = new stdClass();
        $result->condition = FALSE;
        if ($name) {
            $this->load->library('upload');

            $output_dir = 'media/settings/';
            if (!file_exists($output_dir)) {
                mkdir($output_dir, 0755, true);
            }
            $file_extension = pathinfo($_FILES[$name]['name'], PATHINFO_EXTENSION);
            $fileName = date('Ymd-His') . '-' . rand(1000, 9999) . '.' . $file_extension;
            $config['upload_path'] = $output_dir;
            $config['file_name'] = $fileName;
            $config['allowed_types'] = 'gif|jpg|png|webp|svg';
            $config['max_size'] = 5120; //(in kilobyte) 5 MB = 5120 KB


            $this->upload->initialize($config);

            if (!$this->upload->do_upload($name)) {
                $result->error = array('error' => $this->upload->display_errors());
            //if (!move_uploaded_file($_FILES[$name]['tmp_name'], $output_dir . $fileName)) {
            //    $result->error = 'Error in uploading.';
            } else {
                $result->condition = TRUE;
                $result->file_name = $fileName;
                $result->file_path = $output_dir . $fileName;
            }
        }
//        var_dump($result);die();
        return $result;
    }

    //remove image
    public function removeImage() {
        $result = new stdClass();
        $result->condition = FALSE;
        $src = $this->input->get('path');
        if ($src) {
            $image = trim($src, '/');
            if ($image != '' && file_exists($image) && strpos($image, 'media/settings/') == 0) {
                unlink($image);
            }
            $result->condition = TRUE;
        }

        echo json_encode($result);
    }

}

?>
