<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Pages extends Admin_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('pages_m');
    }

    // load pages list
    function index() {
        $this->userHasPermission('pages');
        $this->data['breadcrumb'] = array('مدیریت صفحات');

        //css
        $css = array();
        array_push($css, 'assets/plugins/data-table/css/dataTables.bootstrap.css');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/data-table/js/jquery.dataTables.min.js');
        array_push($js, 'assets/plugins/data-table/js/dataTables.bootstrap.js');
        $this->data['js'] = $js;


        $this->data['subview'] = 'admin/page/index';

        $this->load->view('admin/_layout_main', $this->data);
    }

    function view() {
        $this->userHasPermission('pages', false);
//        $this->data['pages'] = $this->pages_m->get();
        echo $this->load->view('admin/page/index', $this->data, true);
    }

    public function ajax_list() {
        $this->userHasPermission('pages', false);
        $list = $this->pages_m->get_datatables();
        $data = array();
        $no = $_POST['start'];
        $base_url = trim(base_url(), '/');
        foreach ($list as $item) {
            $actions = "";

            // Is rule
            $class = ($item->is_rule == 1) ?  'fa fa-check-circle fa-2x text-success' : 'fa fa-circle-o fa-2x';
            $is_rule_html = "<span><i class=\"$class\"></i></span>";
            
            if (in_array('pages_edit', $this->user_permissions)){
                $is_rule_html = "<a href=\"javascript:void(0)\" title=\"برای انتخاب به عنوان صفحه قوانین کلیک کنید\" class=\"has-tooltip\"  onclick=\"insert('$base_url/admin/pages/rulePage/$item->id', '', '$base_url/admin/pages/view', '#res', '#msg', false, true, 'noty', 'GET')\"><i class=\"$class\"></i></a>";

                // Publish status
                if ($item->publish == 1) {
                    $btn_class = 'success';
                    $title = 'انتشار';
                    $url = "$base_url/admin/pages/un_publish/$item->id";
                } else {
                    $btn_class = 'danger';
                    $title = 'عدم انتشار';
                    $url = "$base_url/admin/pages/publish/$item->id";
                }
            
                $actions .= "<a title=\"ویرایش\" class=\"btn btn-warning btn-round btn-icon has-tooltip\" href=\"$base_url/admin/pages/edit/$item->id\"><i class=\"icon-pencil\"></i></a>";
                $actions .= "<a title=\"$title\" class=\"btn btn-$btn_class btn-round btn-icon has-tooltip\" href=\"javascript: void(0)\" onclick=\"insert('$url', '#frm-main', '$base_url/admin/pages/view', '#res', '#msg', false, true, 'noty' )\"><i class=\"icon-eye\"></i></a>";
            }
            if (in_array('pages_delete', $this->user_permissions)){
                $actions .= "<a title=\"حذف\" class=\"btn btn-danger btn-round btn-icon has-tooltip\" href=\"javascript: void(0)\" onclick=\"deleteRow('$base_url/admin/pages/delete/$item->id','#frm-main','$base_url/admin/pages/view','#res','delete')\"><i class=\"icon-trash\"></i></a>";
            }

            $checkbox = '<input type="checkbox" value="' . $item->id . '">';
            $no++;
            $row = array();
            $row['checkbox'] = $checkbox;
            $row['row'] = $no;
            $row['id'] = $item->id;
            $row['title'] = $item->title;
            $row['is_rule'] = $is_rule_html;
            $row['actions'] = $actions;

            $data[] = $row;
        }

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->pages_m->count_all(),
            "recordsFiltered" => $this->pages_m->count_filtered(),
            "data" => $data,
            "csrf" => $this->security->get_csrf_hash()
        );
        //output to json format
        echo json_encode($output);
    }

    // Add and edit
    function edit($id = null) {
        $this->data['breadcrumb'] = array('مدیریت صفحات');

        //js
        $js = array();
        array_push($js, 'assets/plugins/ckeditor-full/ckeditor.js');
        $this->data['js'] = $js;

        // check exist
        if ($id != null) {
            $page = $this->pages_m->get($id, true);
            if (!$page)
                $id = null;
        }

        if ($id == null) {
            // add
            $this->userHasPermission('pages_add');
            $page = $this->pages_m->getNew();
            $this->data['page'] = $page;
        } else {
            // edit
            $this->userHasPermission('pages_edit');
            $this->data['page'] = $page;
        }

        $this->data['subview'] = 'admin/page/edit';
        $this->load->view('admin/_layout_main', $this->data);
    }

    // Save
    function save() {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'خطای سیستمی.';
        $id = intval($this->input->post('id'));


        $this->form_validation->set_rules('title', 'عنوان صفحه', 'trim|required');
        $this->form_validation->set_rules('slug', 'slug', 'trim|required');
        $this->form_validation->set_rules('content', 'محتوای اصلی', 'required');

        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
        $this->form_validation->set_message('numeric', '%s را به درستی وارد نمائید');


        $data = $this->input->post();

        if (isset($data['id'])) {
            $data['id'] = intval($data['id']);
        } else {
            $data['id'] = 0;
        }

        if ($this->form_validation->run() != FALSE) {

            $data = array(
                'title'    => $this->security->xss_clean($this->input->post('title')),
                'slug'    => $this->security->xss_clean(str_replace(' ', '-', $this->input->post('slug'))),
                'content' => $this->input->post('content'), //for tags
                'meta_title' => $this->security->xss_clean($this->input->post('meta_title')),
                'meta_keywords' => $this->security->xss_clean($this->input->post('meta_keywords')),
                'meta_description' => $this->security->xss_clean($this->input->post('meta_description')),
                'updated' => date('Y-m-d H:i:s'),
            );
            //edit
            if ($id > 0) {
                // save
                $this->userHasPermission('pages_edit', false, $result);
                $id = $this->pages_m->save($data, $id);
            }
            //add
            else {
                // save
                $this->userHasPermission('pages_add', false, $result);
                $id = $this->pages_m->save($data);
            }

            $result->msg = 'با موفقیت ثبت گردید.';
            $this->session->set_flashdata('admin_success', $result->msg);
            $result->condition = true;
            $result->url = base_url('admin/pages');
        } else {
            $result->msg = validation_errors();
        }

        echo json_encode($result);
    }

    function publish($id = '') {
        $data = array(
            'publish' => '1'
        );

        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('pages_edit', false, $result);

        $id = intval($id);
        if ($id > 0) {
            $this->pages_m->update($data, $id);
            $result->msg = 'صفحه مورد نظر با موفقیت در وضعیت انتشار قرار گرفت.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->pages_m->update($data, $id);
                    }
                    $result->msg = 'صفحه های مورد نظر با موفقیت در وضعیت انتشار قرار گرفتند.';
                    $result->condition = true;
                }
            }
        }

        echo json_encode($result);
    }

    function un_publish($id = '') {
        $data = array(
            'publish' => '0'
        );

        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('pages_edit', false, $result);

        $id = intval($id);
        if ($id > 0) {
            $this->pages_m->update($data, $id);
            $result->msg = 'صفحه مورد نظر با موفقیت در وضعیت عدم انتشار قرار گرفت.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->pages_m->update($data, $id);
                    }
                    $result->msg = 'صفحه های مورد نظر با موفقیت در وضعیت عدم انتشار قرار گرفتند.';
                    $result->condition = true;
                }
            }
        }

        echo json_encode($result);
    }

    function delete($id = '') {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('pages_delete', false, $result);

        $id = intval($id);
        if ($id > 0) {
            $this->pages_m->delete($id);
            $result->msg = 'صفحه مورد نظر با موفقیت حذف شد.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->pages_m->delete($id);
                    }
                    $result->msg = 'صفحه های مورد نظر با موفقیت حذف شدند.';
                    $result->condition = true;
                }
            }
        }
        
        echo json_encode($result);
    }

    // Set is rule
    function rulePage($id) {
        $data = array(
            'is_rule' => '1'
        );
        $dataReset =  array(
            'is_rule' => '0'
        );

        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'خطای سیستمی';

        $this->userHasPermission('pages_edit', false, $result);

        $id = intval($id);
        if ($id > 0) {
            $this->pages_m->update_by($dataReset, array('id<>'=>$id));
            $this->pages_m->update($data, $id);
            $result->msg = 'صفحه مورد نظر به عنوان صفحه قوانین انتخاب گردید.';
            $result->condition = true;
        }

        echo json_encode($result);
    }
}
?>
