<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Notices extends Admin_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('notices_m');
        $this->load->model('seen_notices_m');
    }

    // load notices list
    function index() {
        $this->userHasPermission('notices');
        $this->data['breadcrumb'] = array('اطلاعیه ها');

        //css
        $css = array();
        array_push($css, 'assets/plugins/data-table/css/dataTables.bootstrap.css');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/data-table/js/jquery.dataTables.min.js');
        array_push($js, 'assets/plugins/data-table/js/dataTables.bootstrap.js');
        $this->data['js'] = $js;


        $this->data['subview'] = 'admin/notice/index';

        $this->load->view('admin/_layout_main', $this->data);
    }

    function view() {
        $this->userHasPermission('notices', false);
        echo $this->load->view('admin/notice/index', $this->data, true);
    }

    public function ajax_list() {
        $this->userHasPermission('notices', false);

        $list = $this->notices_m->get_datatables();
        $data = array();
        $no = $_POST['start'];
        $base_url = trim(base_url(), '/');
        foreach ($list as $item) {
            $actions = "";
            if (in_array('notices_edit', $this->user_permissions)){
                if ($item->publish == 1) {
                    $btn_class = 'success';
                    $title = 'انتشار';
                    $url = "$base_url/admin/notices/un_publish/$item->id";
                } else {
                    $btn_class = 'danger';
                    $title = 'عدم انتشار';
                    $url = "$base_url/admin/notices/publish/$item->id";
                }
                $actions .= "<a title=\"ویرایش\" class=\"btn btn-warning btn-round btn-icon has-tooltip\" href=\"$base_url/admin/notices/edit/$item->id\"><i class=\"icon-pencil\"></i></a>";
                $actions .= "<a title=\"$title\" class=\"btn btn-$btn_class btn-round btn-icon has-tooltip\" href=\"javascript: void(0)\" onclick=\"insert('$url', '#frm-main', '$base_url/admin/notices/view', '#res', '#msg', false, true, 'noty' )\"><i class=\"icon-eye\"></i></a>";
            }
            
            if (in_array('notices_delete', $this->user_permissions)){
                $actions .= "<a title=\"حذف\" class=\"btn btn-danger btn-round btn-icon has-tooltip\" href=\"javascript: void(0)\" onclick=\"deleteRow('$base_url/admin/notices/delete/$item->id','#frm-main','$base_url/admin/notices/view','#res','delete')\"><i class=\"icon-trash\"></i></a>";
            }

            $no++;
            $row = array();
            $row['checkbox'] = '<input type="checkbox" value="' . $item->id . '">';
            $row['id'] = $item->id;
            $row['row'] = $no;
            $row['title'] = $item->title;
            $row['start_time'] = $this->pdate->date('Y/m/d H:i',strtotime($item->start_time));
            $row['end_time'] = $this->pdate->date('Y/m/d H:i',strtotime($item->end_time));
            $row['actions'] = $actions;

            $data[] = $row;
        }

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->notices_m->count_all(),
            "recordsFiltered" => $this->notices_m->count_filtered(),
            "data" => $data,
            "csrf" => $this->security->get_csrf_hash()
        );
        //output to json format
        echo json_encode($output);
    }

    // Add and edit
    function edit($id = null) {
        //$this->data['meta_title'] = '';
        $this->data['breadcrumb'] = array('اطلاعیه‌ها');

        //css
        $css = array();
        array_push($css, 'assets/plugins/persian-datepicker/css/persian-datepicker.css?1');
        array_push($css, 'assets/plugins/clockpicker/dist-new/jquery-clockpicker.min.css');
        array_push($css, 'assets/plugins/summernote/dist/summernote.css');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/persian-date/persian-date.js?1');
        array_push($js, 'assets/plugins/persian-datepicker/js/persian-datepicker.js?1');
        array_push($js, 'assets/plugins/clockpicker/dist-new/bootstrap-clockpicker-diracleo.js');
        array_push($js, 'assets/plugins/summernote/dist/summernote.min.js');
        array_push($js, 'assets/plugins/summernote/dist/summernote-ext-rtl.js');
        $this->data['js'] = $js;

        // check exist
        if ($id != null) {
            $notice = $this->notices_m->get($id, true);
            if (!$notice)
                $id = null;
        }

        if ($id == null) {
            // add
            $this->userHasPermission('notices_add');
            $notice = $this->notices_m->getNew();
            
            $notice->start_date = '';
            $notice->start_clock = '';
            $notice->end_date = '';
            $notice->end_clock = '';
        } else {
            // edit
            $this->userHasPermission('notices_edit');

            $this->load->library('pdate');
            $notice->start_date = date('Y/m/d',strtotime($notice->start_time));
            $notice->start_clock = date('H:i',strtotime($notice->start_time));
            $notice->end_date = date('Y/m/d',strtotime($notice->end_time));
            $notice->end_clock = date('H:i',strtotime($notice->end_time));
        }

        $this->data['notice'] = $notice;

        $this->data['subview'] = 'admin/notice/edit';
        $this->load->view('admin/_layout_main', $this->data);
    }

    // save
    function save() {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'خطای سیستمی.';
        $result->csrf = $this->security->get_csrf_hash();

        $id = intval($this->input->post('id'));

        $_POST['start_date'] = englishNumber($this->input->post('start_date'));
        $_POST['end_date'] = englishNumber($this->input->post('end_date'));

        $this->form_validation->set_rules('title', 'عنوان', 'trim|required');
        $this->form_validation->set_rules('content', 'متن اطلاعیه', 'trim|required');
        $this->form_validation->set_rules('start_date', 'تاریخ شروع', ['trim', 'required', 'regex_match[/^1(3|4)(\d{2})\/(0?[1-9]|1[012])\/(0?[1-9]|[12][0-9]|3[01])$/]']);
        $this->form_validation->set_rules('end_date', 'تاریخ پایان', ['trim', 'required', 'regex_match[/^1(3|4)(\d{2})\/(0?[1-9]|1[012])\/(0?[1-9]|[12][0-9]|3[01])$/]']);
        $this->form_validation->set_rules('start_clock', 'ساعت شروع', ['trim', 'required', 'regex_match[/^([01]?\d|2[0-3]):([0-5]?\d)$/]']);
        $this->form_validation->set_rules('end_clock', 'ساعت پایان', ['trim', 'required', 'regex_match[/^([01]?\d|2[0-3]):([0-5]?\d)$/]']);

        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
        $this->form_validation->set_message('regex_match', 'لطفا %s را صحیح وارد کنید');

        if ($this->form_validation->run() != FALSE) {

            $this->load->library('pdate');

            // Start time
            [$year, $month, $day] = explode('/', $this->input->post('start_date'));
            [$hours, $minute] = explode(':', $this->input->post('start_clock'));
            $stamp = $this->pdate->mktime($hours, $minute, 0, $month, $day, $year);
            $start_time = $this->pdate->date("Y-m-d H:i:s", $stamp, false, false);

            // End time
            [$year, $month, $day] = explode('/', $this->input->post('end_date'));
            [$hours, $minute] = explode(':', $this->input->post('end_clock'));
            $stamp = $this->pdate->mktime($hours, $minute, 0, $month, $day, $year);
            $end_time = $this->pdate->date("Y-m-d H:i:s", $stamp, false, false);

            $data = array(
                'title' => $this->input->post('title'),
                'start_time' => $start_time,
                'end_time' => $end_time,
                'publish' => ($this->input->post('publish') == 1) ? 1 : 0,
                'content' => $this->input->post('content'),
            );

            // Edit
            if ($id > 0) {
                $this->userHasPermission('notices_edit', false, $result);
                $id = $this->notices_m->save($data, $id);
            }
            // Add
            else {
                $this->userHasPermission('notices_add', false, $result);
                $id = $this->notices_m->save($data);
            }

            $result->msg = 'با موفقیت ثبت گردید.';
            $this->session->set_flashdata('admin_success', $result->msg);
            $result->condition = true;
            $result->url = base_url('admin/notices');
        } else {
            $result->msg = validation_errors();
        }

        echo json_encode($result);
    }

    function publish($id = '') {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('notices_edit', false, $result);

        $ids = [];
        $id = intval($id);
        if ($id > 0) {
            $ids[] = $id;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $ids[] =  intval($id);
                    }
                }
            }
        }

        if($ids){
            $str_ids = implode(',', $ids);
            $this->notices_m->update_by(['publish' => 1], ["id IN ($str_ids)" => null]);

            if(count($ids) == 1){
                $result->msg = 'اطلاعیه مورد نظر با موفقیت در وضعیت انتشار قرار گرفت.';
            } else {
                $result->msg = 'اطلاعیه‌های مورد نظر با موفقیت در وضعیت انتشار قرار گرفتند.';
            }
            $result->condition = true;
        }

        echo json_encode($result);
    }

    function un_publish($id = '') {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('notices_edit', false, $result);

        $ids = [];
        $id = intval($id);
        if ($id > 0) {
            $ids[] = $id;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $ids[] =  intval($id);
                    }
                }
            }
        }

        if($ids){
            $str_ids = implode(',', $ids);
            $this->notices_m->update_by(['publish' => 0], ["id IN ($str_ids)" => null]);

            if(count($ids) == 1){
                $result->msg = 'اطلاعیه مورد نظر با موفقیت در وضعیت عدم انتشار قرار گرفت.';
            } else {
                $result->msg = 'اطلاعیه‌های مورد نظر با موفقیت در وضعیت عدم انتشار قرار گرفتند.';
            }
            $result->condition = true;
        }

        echo json_encode($result);
    }

    function delete($id = '') {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';
        
        $this->userHasPermission('notices_delete', false, $result);

        $ids = [];
        $id = intval($id);
        if ($id > 0) {
            $ids[] = $id;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $ids[] =  intval($id);
                    }
                }
            }
        }

        if($ids){
            $str_ids = implode(',', $ids);
            $this->notices_m->delete_by(["id IN ($str_ids)" => null]);

            $this->load->model('seen_notices_m');
            $this->seen_notices_m->delete_by(["notice_id IN ($str_ids)" => null]);

            if(count($ids) == 1){
                $result->msg = 'اطلاعیه مورد نظر با موفقیت حذف شد.';
            } else {
                $result->msg = 'اطلاعیه‌های مورد نظر با موفقیت حذف شدند.';
            }
            $result->condition = true;
        }
       
        echo json_encode($result);
    }


    public function uploadImage() {

        if (isset($_FILES['image']) && $_FILES['image']) {

            $this->load->library('upload');
            $file_extension = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
            $fileName = date('Ymd-His') . '-' . random_str(15) . '.' . $file_extension;
            $output_dir = "media/notices/";
            if (!file_exists($output_dir)) {
                mkdir($output_dir, 0755, true);
            }
            
            $config['upload_path'] = $output_dir;
            $config['file_name'] = $fileName;
            $config['allowed_types'] = 'gif|jpg|png';
            $config['max_size'] = 5120; //(in kilobyte) 5 MB = 5120 KB


            $this->upload->initialize($config);

            if (!$this->upload->do_upload('image')) {
                //$result->error = array('error' => $this->upload->display_errors());
            } else {
                echo $output_dir . $fileName;
            }
        }
    }

}

?>
