<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Users extends Frontend_Controller
{

    private $destention = 'home';
    private $max_submit = 3;

    function __construct()
    {
        parent::__construct();
        $this->data['unpublish_footer'] = false;
    }

    public function login()
    {
        if ($this->loggedin()) {
            //اگر کاربر لاگین کرده بود برو به داشبورد
            redirect($this->destention);
        }

        // اگر از مرحله 3 خرید به اینجا آمده بود آنگاه مسیر برگشتش را درست می‌کنیم
        $product_id = intval($this->input->get('product'));
        if($product_id){
            $this->session->set_userdata('last_page', base_url("product/$product_id"));
        }

        $submit = $this->input->post('submit');
        if ($submit) {
            //چند بار اول کد امنیتی نباشد
            $captcha_count = $this->session->userdata('login_captcha_count');
            $captcha_count = ($captcha_count) ? $captcha_count + 1 : 1;
            $this->session->set_userdata('login_captcha_count', $captcha_count);
            if ($captcha_count > $this->max_submit) {
                $captcha = $this->session->userdata('captcha');
                $this->session->unset_userdata('captcha');
            }

            $this->form_validation->set_rules('username', 'شماره همراه', ['trim', 'required', 'regex_match[/^9\d{9}$|^09\d{9}$/]']);
            if (isset($captcha)) {
                $this->form_validation->set_rules('captcha', 'کد امنیتی', "required|callback_is_equal[$captcha]");
            }

            $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
            $this->form_validation->set_message('is_equal', 'لطفا %s را صحیح وارد کنید');
            $this->form_validation->set_message('regex_match', '%s صحیح نیست.');

            if ($this->form_validation->run()) {
                $username = strtolower($this->input->post('username'));
                if (strlen($username) == 10) {
                    $username = '0' . $username;
                }
                $cell_phone = $username;

                // اعتبارسنجی درست بوده و باید در دیتابیس کاربر را چک کنیم
                $where = [
                    'username' => $username,
                    'type' => 'customer',
                    'deleted' => 0
                ];
                $user = $this->users_m->get_by('id, username, block', $where, true);
                if ($user) {
                    //این کاربر وجود دارد
                    //حال چک می کنیم بلاک نشده باشد
                    if ($user->block) {
                        $this->session->set_flashdata('frontend_error', 'کاربر گرامی متاسفانه دسترسی شما مسدود شده است. لطفا علت را از مدیر سایت پیگیری کنید.');
                        redirect('login');
                    }
                } else {
                    //این نام کاربری در دیتابیس وجود ندارد بنابرای ابتدا در دیتابیس ثبتش می کنیم
                    $data = [
                        'username' => $username,
                        'cell_phone' => $cell_phone,
                        'type' => 'customer',
                    ];
                    $id = $this->users_m->save($data);
                    if (!$id) {
                        $this->session->set_flashdata('frontend_error', 'خطای در ثبت شماره همراه شما رخ داده است. لطفا با مدیر سایت تماس بگیرید.');
                        redirect('login');
                    }
                }

                //ارسال کد تایید
                $this->sendVerifyCode($cell_phone);
                redirect("verify");
            } else {
                $this->data['message_danger'] = validation_errors();
            }
        }

        //meta
        $this->data['meta_title'] = 'ورود به سایت';

        //captcha
        $captcha_count = $this->session->userdata('login_captcha_count');
        if ($captcha_count && $captcha_count >= $this->max_submit) {
            $this->data['captcha_image'] = $this->frontend_general->create_captcha();
        }

        // Rules page
        $this->load->model('pages_m');
        $where = array('publish' => 1, 'is_rule' => 1);
        $this->data['rules_page'] = $this->pages_m->get_by('id, title, content', $where, true);

        // Image
        $this->data['bg_image_side'] = $this->getBackgroundImageSide();

        // Canonical
        $this->data['canonical'] = base_url("login");

        $this->data['content'] = 'user/login';
        $this->load->view('_layout_main', $this->data);
    }

    //remember me
    private function rememberMe($user_id, $username)
    {
        $this->load->model('login_cookies_m');
        $user_session = hash('sha512', $user_id . $username);
        $token = hash('sha512', uniqid(rand(), TRUE));
        $now = date('Y-m-d H:i:s');
        $data = array(
            'user_session' => $user_session,
            'username' => $username,
            'token' => $token,
            'updated' => $now,
            'created' => $now,
        );
        if ($this->login_cookies_m->save($data)) {
            $value = $user_session . '|' . md5($username) . '|' . $token;
            // 1 months -> 1*30 days
            set_cookie($this->login_name_cookie, $value, 3600 * 24 * 30);
        }
    }

    //verify
    public function verify()
    {
        $this->load->model('verifications_m');

        if ($this->loggedin()) {
            redirect($this->destention);
        }
        $js = array();
        array_push($js, 'assets/js/pages/verify.js?3');
        $this->data['js'] = $js;

        $cell_phone = $this->session->userdata('verify_cellphone');
        if (!$cell_phone && !preg_match('/^9\d{9}$|^09\d{9}$/', $cell_phone)) {
            //داره فضولی میکنه
            redirect('login');
        }
        if (strlen($cell_phone) == 10) {
            $cell_phone = '0' . $cell_phone;
        }

        $submit = $this->input->post('submit');
        if ($submit) {
            //چند بار اول کد امنیتی نباشد
            $captcha_count = $this->session->userdata('verify_captcha');
            $captcha_count = ($captcha_count) ? $captcha_count + 1 : 1;
            $this->session->set_userdata('verify_captcha', $captcha_count);
            if ($captcha_count > $this->max_submit) {
                $captcha = $this->session->userdata('captcha');
                $this->session->unset_userdata('captcha');
            }

            $this->form_validation->set_rules('code', 'کد فعال سازی', 'trim|required');
            if (isset($captcha)) {
                $this->form_validation->set_rules('captcha', 'کد امنیتی', "required|callback_is_equal[$captcha]");
            }

            $this->form_validation->set_message('required', 'وارد کردن %s الزامی است.');
            $this->form_validation->set_message('is_equal', 'لطفا %s را صحیح وارد کنید.');

            if ($this->form_validation->run() != FALSE) {
                $code = $this->input->post('code');
                //ابتدا چک می کنیم که این شماره در جدول کاربران وجود دارد که غیر فعال هم باشد
                $where = array(
                    'username' => $cell_phone,
                    // 'activation' => 0,
                    'type' => 'customer',
                    'deleted' => 0,
                );
                $user = $this->users_m->get_by('id, first_name, last_name, email , national_code, username, activation, matched_fields', $where, TRUE);
                if ($user) {
                    //حالا آخرین کدی را که براش فرستادیم رو می کشیم بیرون
                    $last_time = date('Y-m-d H:i:s', strtotime(' -10 minutes'));
                    $where = array(
                        'cell_phone' => $cell_phone,
                        'created >' => $last_time,
                        'used' => 0,
                    );
                    $verifications = $this->verifications_m->get_by(NULL, $where);
                    if ($verifications) {
                        $list_codes = array_map(function ($item) {
                            return $item->code;
                        }, $verifications);
                        if (in_array($code, $list_codes)) {
                            //همه چی اوکی هست
                            $this->verifications_m->update_by(['used' => 1], ['cell_phone' => $cell_phone]);

                            //فعال می شود
                            if(!$user->activation){
                                // اگر اطلاعاتی در ثبت سفارش داشت آن را برای پروفایلش ذخیره می کنیم
                                $order_user_info = $this->session->userdata('order_user_info');

                                $data = array(
                                    'activation' => 1,
                                    // 'created' => date('Y-m-d H:i:s')
                                );
                                if(isset($order_user_info->first_name) && $order_user_info->first_name && !$user->first_name){
                                    $data['first_name'] = $order_user_info->first_name;
                                }
                                if(isset($order_user_info->last_name) && $order_user_info->last_name && !$user->last_name){
                                    $data['last_name'] = $order_user_info->last_name;
                                }
                                if(isset($order_user_info->email) && $order_user_info->email && !$user->email){
                                    $data['email'] = $order_user_info->email;
                                }
                                if(isset($order_user_info->national_code) && $order_user_info->national_code && !$user->national_code){
                                    $data['national_code'] = $order_user_info->national_code;
                                }

                                $this->users_m->save($data, $user->id);
                                $this->session->unset_userdata('order_user_info');

                                // Signup gift
                                $gift = $this->settings_m->getSingle('signup_gift');
                                if($gift){
                                    $this->load->model('transactions_m');
                                    $this->transactions_m->save([
                                        'user_id' => $user->id,
                                        'amount' => $gift,
                                        'type' => 'signup',
                                        'completed' => 1,
                                    ]);
                                }
                            }

                            $this->session->unset_userdata('verify_cellphone');

                            // کاربر رو در سشن بریز
                            $this->session->set_userdata($this->login_name_session, $user->id);
                            $this->rememberMe($user->id, $user->username);

                            // Notifications
                            if($this->notices->list){
                                $this->notices = $this->data['notices'] = $this->notices_m->getCurrentNotices();
                            }

                            // چک می‌کنیم که نیاز به استعلام دارد یا خیر
                            $user->matched_fields = ($user->matched_fields) ? json_decode($user->matched_fields) :  [];
                            if(
                                in_array('identity_inquiry', $this->settings->verify_when_buy) && 
                                (!in_array('national_code', $user->matched_fields) || !in_array('birth_date', $user->matched_fields))
                            ){
                                redirect('identity-inquiry');
                            }

                            // redirect($this->destention);
                            $this->redirect();
                        } else {
                            $this->data['error_message'] = 'کد وارد شده صحیح نیست.';
                        }
                    } else {
                        $this->data['error_message'] = 'کاربر گرامی کد فعال سازی برای این شماره ثبت نگردیده است. لطفا در خواست کد جدید بدهید';
                    }
                } else {
                    //داره فضولی میکنه
                    redirect('login');
                }
            } else {
                $this->data['error_message'] = validation_errors();
            }
        }

        $this->data['cell_phone'] = $cell_phone;

        $this->data['meta_title'] = 'تایید شماره همراه';

        // به دست آوردن زمان برای ارسال بعدی
        $remain_seconds = 0;
        $recent_request = $this->verifications_m->get_by('created', [
            'cell_phone' => $cell_phone,
            'used' => 0
        ], true, 'id DESC');
        if($recent_request){
            $last_time = strtotime($recent_request->created);
            $next_allowed_time = $last_time + $this->verify_code_cooldown;
            $remain_seconds = $next_allowed_time - time(); // تعداد ثانیه باقی‌مانده

            if ($remain_seconds < 0) {
                $remain_seconds = 0; // اگر زمان گذشته باشد
            }
        }
        $this->data['remain_seconds'] = $remain_seconds;
        $this->data['verify_code_cooldown'] = $this->verify_code_cooldown;

        //captcha
        $captcha_count = $this->session->userdata('verify_captcha');
        if ($captcha_count && $captcha_count >= $this->max_submit) {
            $this->data['captcha_image'] = $this->frontend_general->create_captcha();
        }

        // Image
        $this->data['bg_image_side'] = $this->getBackgroundImageSide();

        $this->data['content'] = 'user/verify';
        $this->load->view('_layout_main', $this->data);
    }

    //دریافت کد جدید برای تایید شماره همراه
    public function getNewCodeForVeify()
    {
        $this->load->model('verifications_m');

        $result = new stdClass();
        $result->condition = FALSE;
        $result->msg = 'دقایقی دیگر تلاش کنید.';

        $cell_phone = $this->session->userdata('verify_cellphone');
        if (!$cell_phone && !preg_match('/^9\d{9}$|^09\d{9}$/', $cell_phone)) {
            //داره فضولی میکنه
            $result->msg = 'کاربر گرامی از ابتدا ثبت نام کنید.';
            echo json_encode($result);
            die();
        }
        if (strlen($cell_phone) == 10) {
            $cell_phone = '0' . $cell_phone;
        }

        //ابتدا چک می کنیم که این شماره در جدول کاربران وجود دارد که غیر فعال هم باشد
        $where = array(
            'username' => $cell_phone,
            // 'activation' => 0,
            'type' => 'customer',
            'deleted' => 0,
        );
        $user = $this->users_m->get_by('id, username', $where, TRUE);
        if (!$user) {
            //داره فضولی میکنه
            $result->msg = 'کاربر گرامی از ابتدا ثبت نام کنید.';
            echo json_encode($result);
            die();
        }

        // بررسی آخرین ارسال در چند دقیقه گذشته
        $last_time = date('Y-m-d H:i:s', strtotime("-{$this->verify_code_cooldown} seconds"));
        $recent_request = $this->verifications_m->get_by('id', [
            'cell_phone' => $cell_phone,
            'created >' => $last_time,
            'used' => 0
        ], true);
        if ($recent_request) {
            $result->msg = 'دقایقی دیگر تلاش کنید.';
        } else {
            $code = mt_rand(10000, 99999);

            //Send sms
            $settings = $this->settings_m->getSettings(['sms', 'site_name']);
            $settings->sms = json_decode($settings->sms);
            if($settings->sms->active && $settings->sms->api_key && $settings->sms->api_key){
                $this->load->library($settings->sms->active, null, 'sms');
                if($settings->sms->patterns->verify){
                    $sms_status = $this->sms->send_by_token($settings->sms->api_key, $settings->sms->from, $cell_phone, $settings->sms->patterns->verify, $code);
                } else {
                    $message = "کد تایید شماره همراه شما: $code";
                    $message .= "\n" . $this->settings->site_name;
                    $sms_status = $this->sms->send($settings->sms->api_key, $settings->sms->from, $cell_phone, $message);
                }
                if ($sms_status) {
                    $data = array(
                        'cell_phone' => $cell_phone,
                        'code' => $code,
                    );
                    $this->verifications_m->save($data);

                    $result->msg = 'یک کد فعال سازی جدید برای شما ارسال گردید.';
                    $result->condition = TRUE;
                } else {
                    $result->msg = 'متاسفانه در ارسال پیامک مشکلی رخ داده است. از قسمت تماس با ما جهت رفع مشکل استفاده نمایید.' . $this->sms->get_error();
                }
            } else{
                $result->msg = 'کاربر گرامی در ارسال پیامک مشکلی رخ داده است. از قسمت تماس با ما جهت رفع مشکل استفاده نمایید.';
            }
        }

        echo json_encode($result);
    }

    // از سشن بررسی می کند که آیا کاربر وارد شده
    public function loggedin()
    {
        if ($this->user_login)
            return true;
        return false;
    }

    //logout
    public function logout()
    {
        $this->session->unset_userdata($this->login_name_session);
        delete_cookie($this->login_name_cookie);

        if($this->session->flashdata('frontend_error')){
            $message = $this->session->flashdata('frontend_error');
            $this->session->set_flashdata('frontend_error', $message);
        }

        redirect($this->destention);
    }

    //for captcha
    function is_equal($str, $value)
    {
        return (strtoupper($str) === strtoupper($value));
    }

    //reload captcha ajax
    function create_captcha()
    {
        $captcha_image = $this->frontend_general->create_captcha();
        echo $captcha_image;
    }

    public function editProfile()
    {
        if (!$this->loggedin()) {
            //لاگین نکرده بود برو فرم لاگین 
            redirect('login');
        }

        $user = $this->users_m->get_by(null, array('id' => $this->user_login->id), true);
        if ($user) {
            $this->data['user'] = $user;
        } else {
            redirect('logout');
        }

        $submit = $this->input->post('submit');

        if ($submit) {
            if(!in_array('birth_date', $this->user_login->matched_fields)){
                $this->form_validation->set_rules('first_name', 'نام', 'trim');
                $this->form_validation->set_rules('last_name', 'نام خانوادگی', 'trim');
            }
            if(!in_array('national_code', $this->user_login->matched_fields)){
                $this->form_validation->set_rules('national_code', 'کد ملی', 'trim|callback_validNationalCode');
            }
            $this->form_validation->set_rules('email', 'ایمیل', 'trim|valid_email');

            $this->form_validation->set_message('required', '%s الزامی است.');
            $this->form_validation->set_message('in_list', '%s را صحیح انتخاب کنید');
            // $this->form_validation->set_message('validNationalCode', 'لطفا %s را صحیح وارد کنید');

            if ($this->form_validation->run() != FALSE) {
                $email = $this->security->xss_clean($this->input->post('email'));

                // اینجا چک میکنیم که ایمیل دامنه ایمیل مجاز باشد
                if($email){
                    $this->load->model('blocks_m');
                    if($this->blocks_m->isEmailBlacklisted($email)){
                        $this->blocks_m->smartBlockUsers($this->user_login->id, 'profile', $email);

                        $message = 'شما از ایمیل غیر مجاز استفاده کردید و بلاک شدید. لطفا موضوع را از طریق صفحه تماس با ما پیگیری کنید.';
                        $this->session->set_flashdata('frontend_error', $message);
                        redirect('users/logout');
                    }
                }

                $user_id = $this->user_login->id;

                $data = [
                    'email' => $email,
                ];
                if(!in_array('birth_date', $this->user_login->matched_fields)){
                    $data['first_name'] = $this->security->xss_clean($this->input->post('first_name'));
                    $data['last_name'] = $this->security->xss_clean($this->input->post('last_name'));
                }
                if(!in_array('national_code', $this->user_login->matched_fields)){
                    $data['national_code'] = $this->input->post('national_code');
                }

                // Image
                $image_result = $this->uploadImage('image');
                if ($image_result->condition) {
                    $source_image = $image_result->file_path;
                    list($width, $height, $type, $attr) = getimagesize($source_image);

                    if ($width != 300 || $height != 300) {
                        //در این حالت نیاز به برش و تغییر اندازه داریم 
                        $this->load->library('image_lib');
                        $config['source_image'] = $source_image;
                        $config['new_image'] = $source_image;
                        $config['maintain_ratio'] = FALSE;
                        $config['width'] = 300;
                        $config['height'] = 300;

                        $this->image_lib->set_enlarge(TRUE);
                        $this->image_lib->thumb($config);
                    }
                    $data['image'] = $source_image;
                }

                if ($this->users_m->save($data, $user_id)) {
                    $this->session->set_flashdata('frontend_success', 'اطلاعات پروفایل شما با موفقیت ویرایش گردید.');
                    redirect('edit-profile');
                } else {
                    $this->data['message_danger'] = 'خطای سیستمی';
                }
            } else {
                $this->data['message_danger'] = validation_errors();
            }
        }

        $this->data['content'] = 'user/edit_profile';
        $this->load->view('_layout_main', $this->data);
    }

    function redirect()
    {
        //اگر صفحه بازگشت مشخص شده بود
        //last_page --> set is in library/frontend_controller.php
        if ($this->session->userdata('last_page')) {
            $last_page = $this->session->userdata('last_page');
            $this->session->unset_userdata('last_page');
            redirect($last_page);
        } else {
            // $message = 'خوش آمدید، ثبت نام شما با موفقیت انجام شد.';
            // $this->session->set_flashdata('frontend_success', $message);
            redirect($this->destention);
        }
    }

    // Get background image side
    private function getBackgroundImageSide($key = 'login_image'){
        $bg_image_side = ($key == 'login_image') ? 'assets/images/bg-form-side.jpg' : 'assets/images/bg-form-side.jpg';
        $login_image = $this->settings_m->getSingle($key);
        if($login_image && file_exists($login_image)){
            $bg_image_side = $login_image;
        }
        return $bg_image_side;
    }

    private function uploadImage($name)
    {
        $result = new stdClass();
        $result->condition = FALSE;
        if($name && isset($_FILES[$name]) && $_FILES[$name]["size"]) {
            $this->load->library('upload');

            // Check upload path
            $output_dir = "media/profiles/";
            if (!file_exists($output_dir)) {
                mkdir($output_dir, 0755, true);
            }

            $file_extension = pathinfo($_FILES[$name]['name'], PATHINFO_EXTENSION);
            $fileName = date('Ymd-His') . '-' . mt_rand(1000, 9999) . '.' . $file_extension;
            $config['upload_path'] = $output_dir;
            $config['file_name'] = $fileName;
            $config['allowed_types'] = 'jpg|png';
            $config['max_size'] = 5120; //(in kilobyte) 5 MB = 5120 KB

            $this->upload->initialize($config);

            if (!$this->upload->do_upload($name)) {
                $result->error = $this->upload->display_errors();
            } else {
                $result->condition = TRUE;
                $result->file_name = $fileName;
                $result->file_path = $output_dir . $fileName;
            }
        }
        
        return $result;
    }

    public function validNationalCode($code) {
        return checkNationalCode($code);
    }

    // استعلام و ثبت کد ملی  و تاریخ تولد 
    public function identityInquiry(){

        // Check login
        if (!$this->loggedin()) {
            redirect('login');
        }

        if(
            in_array('identity_inquiry', $this->settings->verify_when_buy) && 
            (!in_array('national_code', $this->user_login->matched_fields) || !in_array('birth_date', $this->user_login->matched_fields))
        ){
            // ادامه می‌دهیم
        } else {
            // کاربر قبلا استعلام‌های مورد نیاز را گرفته و تایید شده
            redirect('home');
        }

        // اگر از مرحله 3 خرید به اینجا آمده بود آنگاه مسیر برگشتش را درست می‌کنیم
        $product_id = intval($this->input->get('product'));
        if($product_id){
            $this->session->set_userdata('last_page', base_url("product/$product_id"));
        }
        $_POST['birth_date'] = englishNumber($this->input->post('birth_date'));
        $posted_data = (object)$this->input->post();

        // Birth date to gregorian
        if(isset($posted_data->birth_date) && preg_match('/^1(3|4)(\d{2})\/(0?[1-9]|1[012])\/(0?[1-9]|[12][0-9]|3[01])$/', $posted_data->birth_date)){
            $this->load->library('pdate');
            [$year, $month, $day] = explode('/', $posted_data->birth_date);
            $timestamp = $this->pdate->mktime(0, 0, 0, $month, $day, $year);
            $posted_data->birth_date_gregorian = $this->pdate->date("Y-m-d", $timestamp, false, false);
            $_POST['birth_date'] = $this->pdate->date("Y/m/d", $timestamp, false, true);
        }

        $this->data['posted_data'] = $posted_data;
        
        $submit = $this->input->post('submit');
        if ($submit) {
            if(!in_array('national_code', $this->user_login->matched_fields)){
                $this->form_validation->set_rules('national_code', 'کد ملی', 'trim|required|callback_validNationalCode');
            }
            if(!in_array('birth_date', $this->user_login->matched_fields)){

                $this->form_validation->set_rules('birth_date', 'تاریخ تولد', ['trim', 'required', 'regex_match[/^1(3|4)(\d{2})\/(0?[1-9]|1[012])\/(0?[1-9]|[12][0-9]|3[01])$/]']);
            }
            $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است.');
            $this->form_validation->set_message('regex_match', 'لطفا %s را صحیح وارد کنید.');
            $this->form_validation->set_message('exact_length', '%s باید %s رقم باشد.');
            $this->form_validation->set_message('numeric', '%s باید فقط عدد باشد.');
            $this->form_validation->set_message('validNationalCode', 'لطفا %s را صحیح وارد کنید');

            if ($this->form_validation->run() != FALSE) {
                // جلوگیری از درخواست‌های مکرر
                $this->load->model('failed_attempts_m');
                $allow_request = $this->failed_attempts_m->allowAttempt($this->user_login->id);
                if(!$allow_request){
                    $this->data['error_message'] = 'کاربر گرامی، تعداد تلاش های شما بیش از حد مجاز بوده است. لطفا دقایقی دیگر تلاش کنید.';
                } else {

                    $identity_verification = $this->settings_m->getSingle('identity_verification');
                    $identity_verification = json_decode($identity_verification);
                    if(!$identity_verification->token){
                        $this->data['error_message'] = 'سرویس استعلام فعال نیست.';
                    } else {

                        // حالا میریم سراغ استعلام گرفتن
                        $this->load->library('zohal');

                        //  اول کد ملی
                        if(!in_array('national_code', $this->user_login->matched_fields)){
                            $national_code = $this->input->post('national_code');
                            $result = $this->zohal->shahkar($identity_verification->token, $this->user_login->cell_phone, $national_code);
                            if($result){
                                // Save in user table
                                $this->users_m->save([
                                    'national_code' => $national_code,
                                    'matched_fields' => json_encode(['national_code']),
                                ], $this->user_login->id);

                                // Update user login
                                $this->user_login->national_code = $national_code;
                                $this->user_login->matched_fields[] = 'national_code';

                            } else{
                                if($this->zohal->isMatched() === false){
                                    
                                    
                                }
                                $this->data['error_message'] = $this->zohal->getErrorMessage();
                            }
                        }   

                        // دوم استعلام اطلاعات هویتی
                        if(
                            !isset($this->data['error_message']) && 
                            in_array('national_code', $this->user_login->matched_fields) && 
                            !in_array('birth_date', $this->user_login->matched_fields)
                        ){
                            $birth_date = $this->input->post('birth_date');
                            $result = $this->zohal->nationalIdentityInquiry($identity_verification->token, $this->user_login->national_code, $birth_date);
                            if($result){
                                $first_name = $this->zohal->getData()->first_name;
                                $last_name = $this->zohal->getData()->last_name;
                                $father_name = $this->zohal->getData()->father_name;

                                // Save in user table
                                $this->users_m->save([
                                    'birth_date' => $birth_date,
                                    'first_name' => $first_name,
                                    'last_name' => $last_name,
                                    'father_name' => $father_name,
                                    'matched_fields' => json_encode(['national_code', 'birth_date']),
                                ], $this->user_login->id);

                                // Update user login
                                $this->user_login->birth_date = $birth_date;
                                $this->user_login->first_name = $first_name;
                                $this->user_login->last_name = $last_name;
                                $this->user_login->matched_fields[] = 'birth_date';

                            } else{
                                if($this->zohal->isMatched() === false){
                                    // ثبت تلاش ناموفق
                                    $this->failed_attempts_m->save([
                                        'user_id' => $this->user_login->id,
                                        'method' => 'national_identity_inquiry',
                                        'value' => json_encode(['national_code' => $this->user_login->national_code, 'birth_date' => $birth_date]),
                                    ]);
                                } 
                                $this->data['error_message'] = $this->zohal->getErrorMessage();
                            }
                        } 

                        if(!isset($this->data['error_message'])){
                            $this->redirect();
                        }

                        $this->data['user_login'] = $this->user_login;
                    }
                }
            } else {
                $this->data['error_message'] = validation_errors();
            }
            
        }


        //meta
        $this->data['meta_title'] = 'ثبت اطلاعات';

        // Image
        $this->data['bg_image_side'] = $this->getBackgroundImageSide('identity_inquiry_image');

        // CSS & JS
        $this->data['css'] = ['assets/plugins/persian-datepicker/css/persian-datepicker.css?1'];
        $this->data['js'] = [
            'assets/plugins/persian-date/persian-date.js?1',
            'assets/plugins/persian-datepicker/js/persian-datepicker.js?1',
        ];

        // Canonical
        $this->data['canonical'] = base_url("identity-inquiry");

        $this->data['content'] = 'user/identity_inquiry';
        $this->load->view('_layout_main', $this->data);
    }

    public function saveBankCard(){
        $this->load->model('bank_cards_m');

        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;

        // Check login
        if (!$this->loggedin()) {
            $result->message = 'ابتدا وارد سایت شوید.';
            echo json_encode($result);
            die();
        }

        if(!in_array('bank_card', $this->settings->verify_when_buy)){
            $result->message = 'نیازی به ثبت شماره کارت بانکی نیست.';
            echo json_encode($result);
            die();
        }

        if(!in_array('national_code', $this->user_login->matched_fields)){
            $result->message = 'ابتدا کد ملی خود را ثبت کنید.';
            echo json_encode($result);
            die();
        } 

        if(!in_array('birth_date', $this->user_login->matched_fields)){
            $result->message = 'ابتدا تاریخ تولد خود را ثبت کنید.';
            echo json_encode($result);
            die();
        }

        // جلوگیری از درخواست‌های مکرر
        $this->load->model('failed_attempts_m');
        $allow_request = $this->failed_attempts_m->allowAttempt($this->user_login->id);
        if(!$allow_request){
            $result->message = 'کاربر گرامی، تعداد تلاش های شما بیش از حد مجاز بوده است. لطفا دقایقی دیگر تلاش کنید.';
            echo json_encode($result);
            die();
        } 
        
        $identity_verification = $this->settings_m->getSingle('identity_verification');
        $identity_verification = json_decode($identity_verification);
        if(!$identity_verification->token){
            $result->message = 'سرویس استعلام فعال نیست.';
            echo json_encode($result);
            die();
        }

        // چک می‌کنیم شماره کارت صحیح باشد
        $card_number = $this->input->post('card_number');
        if (!preg_match('/^\d{16}$/', $card_number)) {
            $result->message = 'شماره کارت بانکی صحیح نیست.';
            echo json_encode($result);
            die();
        }

        // چک می‌کنیم شماره کارت تکراری نباشد
        $bank_card_db = $this->bank_cards_m->get_by('id, deleted', ['user_id' => $this->user_login->id, 'card_number' => $card_number], true);
        if($bank_card_db && $bank_card_db->deleted == 0){
            $result->message = 'این شماره کارت قبلا ثبت شده است.';
            echo json_encode($result);
            die();
        }

        if($bank_card_db){
            // قبلا ثبت شده بوده و حذف کرده بوده
            $this->bank_cards_m->save(['deleted' => 0], $bank_card_db->id);

            $result->condition = true;
            $result->card_number = $card_number;
            $result->card_number_formated = bankCardFormat($card_number);

            echo json_encode($result);
            die();
        }

        // حالا میریم سراغ استعلام گرفتن
        $this->load->library('zohal');
        $inquiry_result = $this->zohal->checkCardWithNationalCode($identity_verification->token, $this->user_login->national_code, $this->user_login->birth_date, $card_number);
        if($inquiry_result){
            // Priority
            $priority = 1;
            $max_priority = $this->bank_cards_m->get_by('max(priority) as amount', ['user_id' => $this->user_login->id], true);
            if($max_priority && $max_priority->amount){
                $priority = $max_priority->amount;
            }

            $this->bank_cards_m->save([
                'user_id' => $this->user_login->id, 
                'card_number' => $card_number,
                'priority' => $priority,
            ]);

            $result->condition = true;
            $result->card_number = $card_number;
            $result->card_number_formated = bankCardFormat($card_number);


        } else{
            if($this->zohal->isMatched() === false){
                // ثبت تلاش ناموفق
                $this->failed_attempts_m->save([
                    'user_id' => $this->user_login->id,
                    'method' => 'check_card_with_national_code',
                    'value' => json_encode([
                        'national_code' => $this->user_login->national_code, 
                        'birth_date' => $this->user_login->birth_date, 
                        'card_number' => $card_number, 
                    ]),
                ]);
            }
            $result->message = $this->zohal->getErrorMessage();
        }

        echo json_encode($result);
    }
}
