<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Transactions extends Frontend_Controller {

    function __construct() {
        parent::__construct();
        if (!$this->user_login) {
            $this->session->set_userdata('last_page', base_url("/transactions"));
            redirect('login');
        }
    }

    public function index() {

        $this->load->model('transactions_m');
        //تعداد کل تراکنش های این کاربر
        $count_order = $this->transactions_m->getUserTransactions($this->user_login->id, null, null, true);


        //========================BEGIN pagination ========================
        $this->load->library('pagination');

        $config['base_url'] = base_url('/transactions');

        $config['total_rows'] = $count_order;

        // The number of items you intend to show per page
        $config['per_page'] = '10';

        //The number of "digit" links you would like before and after the selected page number
        $config['num_links'] = '5';


        $config['full_tag_open'] = '<ul class="pagination pagination-info">';
        $config['full_tag_close'] = '</ul>';

        $config['first_link'] = 'ابتدا';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';


        $config['last_link'] = 'انتها';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';

        $config['next_link'] = '<i class="fa fa-angle-left"></i>';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';

        $config['prev_link'] = '<i class="fa fa-angle-right"></i>';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';

        $config['cur_tag_open'] = '<li class="active"><a>';
        $config['cur_tag_close'] = '</a></li>';

        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';

        $this->pagination->initialize($config);
        //========================END pagination ========================
        //به دست آوردن تراکنش ها
        $offset = (int) $this->uri->segment(2);
        $limit = $config['per_page'];
        $transactions = $this->transactions_m->getUserTransactions($this->user_login->id, $offset, $limit, false);
        if($transactions){
            $this->load->library('pdate');

            //gatewayes
            $this->load->model('gateways_m');
            $db_gatewayes = $this->gateways_m->get_by('title_en, title_fa', array('deleted'=>0), false);
            $gatewayes = array();
            if($db_gatewayes){
                foreach ($db_gatewayes as $gateway) {
                    $gatewayes[strtolower($gateway->title_en)] = $gateway->title_fa;
                }
            }

            foreach ($transactions as $item) {
                $item->created = $this->pdate->date("j F Y H:i", strtotime($item->created));
                $item->gateway_fa = (isset($gatewayes[strtolower($item->gateway)])) ? $gatewayes[strtolower($item->gateway)] : '';
                if($item->gateway == 'card2card'){
                    $item->detail = json_decode($item->detail);
                    $item->detail->transfer_date = $this->pdate->date("Y/m/d H:i", strtotime($item->detail->transfer_date));
                    $item->detail->customer_card = wordwrap($item->detail->customer_card , 4 , '-' , true);
                    $item->detail->image = ($item->detail->image && file_exists($item->detail->image)) ? base_url($item->detail->image) : '';
                    $item->detail->description = preg_replace('/[^a-z1-9A-Z۱۲۳۴۵۶۷۸۹۰ يكئ آابپتثجچحخدذرزژسشصضطظعغفقکگلمنوهی]/', '', $item->detail->description);
                }
            }
        }
        $this->data['transactions'] = $transactions;
        $this->data['offset'] = $offset;

        // Canonical
        $this->data['canonical'] = base_url("transactions");

        $this->data['content'] = 'transaction/index';
        $this->load->view('_layout_main', $this->data);
    }

}
?>