<?php

/**
* @author Rayanik.com
*/
if (!defined('BASEPATH'))
exit('No direct script access allowed');

class Gift extends Frontend_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('gifts_m');
        $this->load->model('try_gifts_m');
        $this->load->model('transactions_m');
    }
    
    public function save(){
        $result = new stdClass();
        $result->condition = FALSE;
        $result->message = 'کد کارت هدیه وارد شده صحیح نیست.';
        $result->csrf = $this->security->get_csrf_hash();

        // Check active
        if(!in_array($this->settings->show_gift_box, ['buy', 'charge', 'both'])){
            $result->message = 'ثبت کارت هدیه غیر فعال است.';
            echo json_encode($result, JSON_UNESCAPED_UNICODE);
            die();
        }

        // Check login
        if(!$this->user_login){
            $result->message = 'کاربر گرامی برای استفاده از کارت هدیه ابتدا وارد سایت شوید.';
            echo json_encode($result, JSON_UNESCAPED_UNICODE);
            die();
        }

        // Check try
        $now = date('Y-m-d H:i:s');
        $where = array(
            'user_id' => $this->user_login->id,
            'created >=' => date('Y-m-d H:i:s', strtotime('-30 minutes')),
        );
        $number_of_try = $this->try_gifts_m->get_by('COUNT(id) AS number', $where, TRUE)->number;
        if ($number_of_try >= 3) {
            $result->message = 'تلاش‌های شما بیش از حد مجاز بوده است. لطفا دقایقی دیگر تلاش کنید.';
            echo json_encode($result, JSON_UNESCAPED_UNICODE);
            die();
        }

        $this->form_validation->set_rules('gift', 'کد کارت هدیه', 'trim|required');
        $this->form_validation->set_message('required', 'وارد کردن %s اجباری است.');

        if ($this->form_validation->run()) {
            $code = $this->input->post('gift');
            
            // Check exists
            $now = date('Y-m-d');
            $where = array(
                'code' => $code,
                'publish' => 1,
                'start_date <=' => $now,
            );
            $gift = $this->gifts_m->get_by(NULL, $where, TRUE);
            if (!$gift) {
                // Save try
                $this->try_gifts_m->save([
                    'user_id' => $this->user_login->id,
                    'code' => $this->security->xss_clean($code),
                ]);

                $result->message = 'کد کارت هدیه وارد شده صحیح نیست.';
                echo json_encode($result, JSON_UNESCAPED_UNICODE);
                die();
            }
    
            // چک می کنیم که کاربر قبلا از این کد استفاده نکرده باشد
            $where = array(
                'user_id' => $this->user_login->id,
                'type' => 'gift_card',
                'reference' => $gift->code,
                'completed' => 1,
            );
            $transaction = $this->transactions_m->get_by('id, amount', $where, true);
            if ($transaction) {
                $format_amount = number_format($transaction->amount);
                $result->message = "کاربر گرامی شما قبلا از این کد استفاده کرده‌اید و کیف پول شما {$format_amount} تومان شارژ شده است.";
                echo json_encode($result, JSON_UNESCAPED_UNICODE);
                die();
            }
    
            // چک می کنیم منقضی نشده باشد
            if ($gift->end_date < $now) {
                $result->message = 'کارت هدیه مورد نظر منقضی شده است.';
                echo json_encode($result, JSON_UNESCAPED_UNICODE);
                die();
            }
    
            // به دست آوردن تعداد استفاده شده این کارت هدیه
            $where = array(
                'type' => 'gift_card',
                'reference' => $gift->code,
                'completed' => 1
            );
            $number_used = $this->transactions_m->get_by('count(id) AS number', $where, true)->number;
            if ($number_used >= $gift->count) {
                $result->message = 'ظرفیت استفاده از این کارت هدیه پر شده است.';
                echo json_encode($result, JSON_UNESCAPED_UNICODE);
                die();
            }

            // Save transaction
            $this->load->model('transactions_m');
            $transaction_id = $this->transactions_m->save([
                'user_id' => $this->user_login->id,
                'amount' => $gift->amount,
                'type' => 'gift_card',
                'reference' => $gift->code,
                'completed' => 1,
            ]);
            if($transaction_id){
                $result->user_credit = $this->users_m->getCredit($this->user_login->id);
                $result->condition = true;
                $format_amount = number_format($gift->amount);
                $result->message = "تبریک! کیف پول شما {$format_amount} تومان شارژ شد.";
            } else {
                $result->message = 'ناموفق در ثبت تراکنش کارت هدیه. لطف مجدد تلاش کنید.';
            }
            
        }else{
            $result->message = validation_errors();
        }

        
        echo json_encode($result, JSON_UNESCAPED_UNICODE);
    }
}

?>
