<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Auth_call extends Frontend_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('auth_calls_m');

        if (!$this->user_login) {
            $this->session->set_userdata('last_page', base_url("auth-call"));
            redirect('login');
        }

        $this->data['unpublish_footer'] = false;
    }

    private function call(){
        $call_result = new stdClass();
        $call_result->status = FALSE;
        $call_result->message = '';

        // بررسی آخرین ارسال در چند دقیقه گذشته
        $last_time = date('Y-m-d H:i:s', strtotime("-{$this->verify_code_cooldown} seconds"));
        $recent_request = $this->auth_calls_m->get_by('id', [
            'user_id' => $this->user_login->id,
            'created >' => $last_time,
            'used' => 0
        ], true);

        if ($recent_request) {
            $call_result->message = 'لحظاتی پیش درخواست شماثبت شد.';
            return $call_result;
        } 
        
        $code = mt_rand(10000, 99999);

        // Send request
        $settings = $this->settings_m->getSettings(['sms', 'auth_call']);
        $settings->sms = json_decode($settings->sms);
        $settings->auth_call = json_decode($settings->auth_call);
        if($settings->sms->active && $settings->sms->api_key){
            $this->load->library('kavenegar');
            $call_status = $this->kavenegar->send_by_token($settings->sms->api_key, $settings->sms->from, $this->user_login->cell_phone, $settings->auth_call->pattern, $code);
            if ($call_status) {
                $data = array(
                    'user_id' => $this->user_login->id,
                    'code' => $code,
                );
                $this->auth_calls_m->save($data);
                
                $call_result->status = TRUE;
                $call_result->message = 'درخواست شما ثبت شد.';
                return $call_result;
            } else {
                $call_result->message = 'متاسفانه در برقراری تماس مشکلی رخ داده است. از تیکت جهت رفع مشکل استفاده نمایید.' . $this->kavenegar->get_error();
                
            }
        } else {
            $call_result->message = 'کاربر گرامی در برقراری تماس مشکلی رخ داده است. از صفحه تیکت جهت رفع مشکل استفاده نمایید.';
            
        }

        return $call_result;
    }

    public function index()
    {
        if(!$this->checkActiveAuthCall() || $this->user_login->auth_call){
            redirect('home');
        }
       
        $this->data['meta_title'] = 'احراز هویت تلفنی';

        $submit = $this->input->post('submit');
        if ($submit) {
            $call_result = $this->call();
            if($call_result->status){
                $this->session->set_flashdata('frontend_success', $call_result->message);
            } else {
                $this->session->set_flashdata('frontend_error', $call_result->message);
            }

            redirect('auth-call/verify');
        }

        // Image
        $this->data['bg_image_side'] = 'assets/images/bg-form-side.jpg';

        $this->data['content'] = 'auth_call/index';
        $this->load->view('_layout_main', $this->data);
    }

    public function verify()
    {
        $js = array();
        array_push($js, 'assets/js/pages/auth-call.js');
        $this->data['js'] = $js;

        if(!$this->checkActiveAuthCall() || $this->user_login->auth_call){
            redirect('home');
        }
       
        $submit = $this->input->post('submit');
        if ($submit) {
            
            $this->form_validation->set_rules('code', 'کد فعال سازی', 'trim|required');

            $this->form_validation->set_message('required', 'وارد کردن %s الزامی است.');
            $this->form_validation->set_message('is_equal', 'لطفا %s را صحیح وارد کنید.');

            if ($this->form_validation->run() != FALSE) {
                
                $this->load->model('failed_attempts_m');
                $allow_check_code = $this->failed_attempts_m->allowAttemptForAuthCall($this->user_login->id);
                if(!$allow_check_code){
                    $message = 'کاربر گرامی، تعداد تلاش های شما بیش از حد مجاز بوده است. لطفا دقایقی دیگر تلاش کنید.';
                    $this->session->set_flashdata('frontend_error',$message);
                    redirect('auth-call/verify');
                } 

                $code = $this->input->post('code');

                // حالا آخرین کدی را که براش فرستادیم رو می کشیم بیرون
                $last_time = date('Y-m-d H:i:s', strtotime(' -10 minutes'));
                $where = array(
                    'user_id' => $this->user_login->id,
                    'created >' => $last_time,
                    'used' => 0,
                );
                $verifications = $this->auth_calls_m->get_by(NULL, $where);
                if ($verifications) {
                    $list_codes = array_map(function ($item) {
                        return $item->code;
                    }, $verifications);
                    if (in_array($code, $list_codes)) {
                        //همه چی اوکی هست
                        $this->auth_calls_m->update_by(['used' => 1], ['user_id' => $this->user_login->id]);
                        $this->users_m->save(['auth_call' => 1], $this->user_login->id);

                        redirect('auth-call/result');
                    } else {
                        $this->data['error_message'] = 'کد وارد شده صحیح نیست.';

                        // ثبت تلاش ناموفق
                        $this->failed_attempts_m->save([
                            'user_id' => $this->user_login->id,
                            'method' => 'auth_call',
                            'value' => json_encode(['code' => $code]),
                        ]);
                    }
                } else {
                    $this->data['error_message'] = 'کاربر گرامی کد فعال سازی برای این شماره ثبت نگردیده است. لطفا در خواست کد جدید بدهید';
                }
            } else {
                $this->data['error_message'] = validation_errors();
            }
        }

        $this->data['meta_title'] = 'احراز هویت تلفنی';

        // به دست آوردن زمان برای ارسال بعدی
        $remain_seconds = 0;
        $recent_request = $this->auth_calls_m->get_by('created', [
            'user_id' => $this->user_login->id,
            'used' => 0
        ], true, 'id DESC');
        if($recent_request){
            $last_time = strtotime($recent_request->created);
            $next_allowed_time = $last_time + $this->verify_code_cooldown;
            $remain_seconds = $next_allowed_time - time(); // تعداد ثانیه باقی‌مانده

            if ($remain_seconds < 0) {
                $remain_seconds = 0; // اگر زمان گذشته باشد
            }
        }
        $this->data['remain_seconds'] = $remain_seconds;
        $this->data['verify_code_cooldown'] = $this->verify_code_cooldown;

        // Image
        $this->data['bg_image_side'] = 'assets/images/bg-form-side.jpg';

        $this->data['content'] = 'auth_call/verify';
        $this->load->view('_layout_main', $this->data);
    }

    //دریافت کد جدید برای تایید شماره همراه
    public function ajaxNewCall()
    {
        $this->load->model('auth_calls_m');

        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'دقایقی دیگر تلاش کنید.';

        if(!$this->checkActiveAuthCall() || $this->user_login->auth_call){
            $result->msg = 'لطفا برای رفع مشکل از طریق تیکت اقدام کنید.';
            echo json_encode($result, JSON_UNESCAPED_UNICODE);
            return;
        }

        $call_result = $this->call();
        $result->condition = $call_result->status;
        $result->msg = $call_result->message;

        echo json_encode($result, JSON_UNESCAPED_UNICODE);
    }

    public function result(){
        $this->data['meta_title'] = 'احراز هویت تلفنی';

        // Image
        $this->data['bg_image_side'] = 'assets/images/bg-form-side.jpg';

        $this->data['content'] = 'auth_call/result';
        $this->load->view('_layout_main', $this->data);
    }
}
